/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.relationship;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.relationship.HorseRelationshipKey;
import com.equestricraft.core.horse.relationship.HorseRelationshipRepository;

public class HorseRelationship
implements RepositoryEntity<HorseRelationshipKey> {
    private final HorseRelationshipKey key;
    private int interactions;
    private long lastInteractionTime;
    private double friendlinessTowards;

    public HorseRelationship(int horseId, int targetHorseId, int interactions, long lastInteractionTime, double friendlinessTowards) {
        this.friendlinessTowards = friendlinessTowards;
        this.key = new HorseRelationshipKey(horseId, targetHorseId);
        this.interactions = interactions;
        this.lastInteractionTime = lastInteractionTime;
    }

    @Override
    public HorseRelationshipKey getKey() {
        return this.key;
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    public int getTargetHorseId() {
        return this.getKey().targetHorseId();
    }

    public int getInteractions() {
        return this.interactions;
    }

    public void setInteractions(int interactions) {
        this.interactions = interactions;
    }

    public long getLastInteractionTime() {
        return this.lastInteractionTime;
    }

    public void setLastInteractionTime(long lastInteractionTime) {
        this.lastInteractionTime = lastInteractionTime;
    }

    public double getFriendlinessTowards() {
        return this.friendlinessTowards;
    }

    public void setFriendlinessTowards(double friendlinessTowards) {
        this.friendlinessTowards = friendlinessTowards;
    }

    @Override
    public void save() {
        Services.getService(HorseRelationshipRepository.class).update(this);
    }
}

