/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.relationship;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.ProbabilityUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.relationship.HorseRelationship;
import com.equestricraft.core.horse.relationship.HorseRelationshipSession;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class HorseRelationshipAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseRelationshipSession horseRelationshipSession;

    public HorseRelationshipAccessor(EQHorse horse) {
        super(horse);
    }

    public void createInteractionWithHorse(EQHorse otherHorse) {
        this.createInteractionWithHorse(otherHorse, 0.0);
    }

    public void createInteractionWithHorse(EQHorse otherHorse, double friendlinessOffset) {
        TaskScheduler.executeAsyncTask(() -> this.createInteractionImpl(otherHorse, friendlinessOffset));
    }

    private void createInteractionImpl(EQHorse otherHorse, double friendlinessOffset) {
        Optional<HorseRelationship> relationship = horseRelationshipSession.getRelationshipWithHorses(this.horse, otherHorse);
        if (relationship.isPresent()) {
            HorseRelationship r = relationship.get();
            r.setLastInteractionTime(System.currentTimeMillis());
            r.setInteractions(r.getInteractions() + 1);
            if (friendlinessOffset != 0.0) {
                double newFriendliness = NumberUtils.keepWithinRange(r.getFriendlinessTowards() + friendlinessOffset, -100.0, 100.0);
                r.setFriendlinessTowards(newFriendliness);
            }
            r.save();
        } else {
            horseRelationshipSession.createRelationshipWithHorses(this.horse, otherHorse, friendlinessOffset);
        }
    }

    public Optional<Duration> getLastInteractionWithAnyFriend() {
        List<HorseRelationship> friendly = horseRelationshipSession.getFriendlyRelationships(this.horse);
        return friendly.stream().max(Comparator.comparing(HorseRelationship::getLastInteractionTime)).map(HorseRelationship::getLastInteractionTime).map(DateUtils::durationSince);
    }

    public int getInteractionsWithHorse(EQHorse otherHorse) {
        Optional<HorseRelationship> relationship = horseRelationshipSession.getRelationshipWithHorses(this.horse, otherHorse);
        Integer count = relationship.map(HorseRelationship::getInteractions).orElse(0);
        return (int)((float)count.intValue() * this.horse.getMemory().getValue());
    }

    public Optional<Duration> getDurationSinceLastInteractionWitHorse(EQHorse otherHorse) {
        Optional<HorseRelationship> relationship = horseRelationshipSession.getRelationshipWithHorses(this.horse, otherHorse);
        Optional<Duration> lastInteraction = relationship.map(HorseRelationship::getLastInteractionTime).map(DateUtils::durationSince);
        return this.horse.getMemory().test() ? lastInteraction : Optional.empty();
    }

    public double getFriendlinessTowards(EQHorse otherHorse) {
        Optional<HorseRelationship> relationship = horseRelationshipSession.getRelationshipWithHorses(this.horse, otherHorse);
        Double value = relationship.map(HorseRelationship::getFriendlinessTowards).orElse(0.0);
        return this.horse.getMemory().test() ? value : 0.0;
    }

    public boolean offerInteraction(EQHorse otherHorse) {
        double friendliness = this.getFriendlinessTowards(otherHorse);
        friendliness = (friendliness + 100.0) / 2.0;
        return ProbabilityUtils.testPercentageProbability(friendliness);
    }
}

