/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.relationship;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.relationship.HorseRelationship;
import com.equestricraft.core.horse.relationship.HorseRelationshipKey;
import java.util.List;

public class HorseRelationshipDatabase
implements RepositoryDatasource<HorseRelationship, HorseRelationshipKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_TARGET_HORSE_ID = "TARGET_HORSE_ID";
    private static final String COLUMN_INTERACTIONS = "INTERACTIONS";
    private static final String COLUMN_LAST_INTERACTION_TIME = "LAST_INTERACTION_TIME";
    private static final String COLUMN_FRIENDLINESS_TOWARDS = "FRIENDLINESS_TOWARDS";

    @Override
    public void create(HorseRelationship horseRelationship) {
        Query.insertInto("HORSE_RELATIONSHIP").columns(QueryColumn.column(COLUMN_HORSE_ID, horseRelationship.getHorseId()), QueryColumn.column(COLUMN_TARGET_HORSE_ID, horseRelationship.getTargetHorseId()), QueryColumn.column(COLUMN_INTERACTIONS, horseRelationship.getInteractions()), QueryColumn.column(COLUMN_LAST_INTERACTION_TIME, horseRelationship.getLastInteractionTime()), QueryColumn.column(COLUMN_FRIENDLINESS_TOWARDS, horseRelationship.getFriendlinessTowards())).execute();
    }

    @Override
    public List<HorseRelationship> retrieveAll() {
        return Query.selectAllFrom("HORSE_RELATIONSHIP").getList(this::getFromResultRow);
    }

    @Override
    public void update(HorseRelationship horseRelationship) {
        Query.update("HORSE_RELATIONSHIP").set(QueryColumn.column(COLUMN_INTERACTIONS, horseRelationship.getInteractions()), QueryColumn.column(COLUMN_LAST_INTERACTION_TIME, horseRelationship.getLastInteractionTime()), QueryColumn.column(COLUMN_FRIENDLINESS_TOWARDS, horseRelationship.getFriendlinessTowards())).where(QueryColumn.column(COLUMN_HORSE_ID, horseRelationship.getHorseId()), QueryColumn.column(COLUMN_TARGET_HORSE_ID, horseRelationship.getTargetHorseId())).execute();
    }

    private HorseRelationship getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int targetHorseId = row.getInt(COLUMN_TARGET_HORSE_ID);
        int interactions = row.getInt(COLUMN_INTERACTIONS);
        long lastInteractionTime = row.getLong(COLUMN_LAST_INTERACTION_TIME);
        double friendlinessTowards = row.getDouble(COLUMN_FRIENDLINESS_TOWARDS);
        return new HorseRelationship(horseId, targetHorseId, interactions, lastInteractionTime, friendlinessTowards);
    }
}

