/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.relationship;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.relationship.HorseRelationship;
import com.equestricraft.core.horse.relationship.HorseRelationshipDatabase;
import com.equestricraft.core.horse.relationship.HorseRelationshipKey;
import java.util.List;
import java.util.function.Function;

public class HorseRelationshipRepository
extends Repository<HorseRelationship, HorseRelationshipKey> {
    @Service
    private HorseRelationshipDatabase horseRelationshipDatabase;

    @Override
    protected RepositoryDatasource<HorseRelationship, HorseRelationshipKey> getDatasource() {
        return this.horseRelationshipDatabase;
    }

    @Override
    protected Function<HorseRelationship, Object> getIndexFunction() {
        return HorseRelationship::getHorseId;
    }

    public List<HorseRelationship> findByHorse(int horseId) {
        return this.findListByIndexKey(horseId);
    }

    public List<HorseRelationship> findFriendlyByHorse(int horseId) {
        return this.createSearchQuery().filter(r -> r.getHorseId() == horseId).filter(r -> r.getFriendlinessTowards() > 0.0).many();
    }
}

