/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.relationship;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.relationship.HorseRelationship;
import com.equestricraft.core.horse.relationship.HorseRelationshipRepository;
import com.equestricraft.core.horse.relationship.HorseRelationshipSession;
import java.util.List;
import java.util.Optional;

public class HorseRelationshipSessionImpl
implements HorseRelationshipSession {
    @Service
    private HorseRelationshipRepository horseRelationshipRepository;

    @Override
    public Optional<HorseRelationship> getRelationshipWithHorses(EQHorse horse, EQHorse targetHorse) {
        List<HorseRelationship> relationships = this.horseRelationshipRepository.findByHorse(horse.getId());
        return relationships.stream().filter(r -> r.getTargetHorseId() == targetHorse.getId()).findFirst();
    }

    @Override
    public List<HorseRelationship> getFriendlyRelationships(EQHorse horse) {
        return this.horseRelationshipRepository.findFriendlyByHorse(horse.getId());
    }

    @Override
    public void createRelationshipWithHorses(EQHorse horse, EQHorse targetHorse, double friendliness) {
        if (horse.equals(targetHorse)) {
            throw new IllegalArgumentException("Horse cannot interact with itself");
        }
        long time = System.currentTimeMillis();
        this.createRelationship(horse, targetHorse, time, friendliness);
        this.createRelationship(targetHorse, horse, time, friendliness);
    }

    private void createRelationship(EQHorse horse1, EQHorse horse2, long timeStamp, double friendliness) {
        HorseRelationship relationship = new HorseRelationship(horse1.getId(), horse2.getId(), 1, timeStamp, friendliness);
        this.horseRelationshipRepository.add(relationship);
    }
}

