/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.restless;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.collector.ECCollectors;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.restless.RestlessProvider;
import com.equestricraft.core.horse.trait.Trait;
import com.equestricraft.core.horse.trait.TraitVisitor;

public class RestlessTrait
implements Trait {
    @Service
    private static ServiceInstance<RestlessProvider> restlessProviders;

    @Override
    public float getValue(EQHorse horse) {
        return restlessProviders.stream().map(p -> Float.valueOf(p.getOffsetFactor(horse))).collect(ECCollectors.toCombinedFloatPercentage(this.getCoreValue(horse))).floatValue();
    }

    private float getCoreValue(EQHorse horse) {
        if (horse.getAge().getYears() < 2.0) {
            return 1.0f;
        }
        return 0.2f;
    }

    @Override
    public String getName() {
        return I18n.getLabel("horse.trait.restless.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("horse.trait.restless.description");
    }

    @Override
    public <T> T accept(TraitVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

