/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ride;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseCurrentRideDto;
import com.equestricraft.api.common.APIHorseGaitDurationDto;
import com.equestricraft.api.common.APIPlayerDto;
import com.equestricraft.core.horse.ride.APIHorseGaitDurationDtoImpl;
import com.equestricraft.core.horse.ride.HorseCurrentRideAccessor;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.ECPlayer;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;

public class APIHorseCurrentRideDtoImpl
implements APIHorseCurrentRideDto {
    private final HorseCurrentRideAccessor horseCurrentRideAccessor;

    public APIHorseCurrentRideDtoImpl(HorseCurrentRideAccessor horseCurrentRideAccessor) {
        this.horseCurrentRideAccessor = horseCurrentRideAccessor;
    }

    @Override
    public Date getStartTime() {
        return this.horseCurrentRideAccessor.getStartTimeOfRide().orElseThrow();
    }

    @Override
    public APIDurationDto getDuration() {
        Optional<Duration> duration = this.horseCurrentRideAccessor.getTotalDurationOfRide();
        return duration.map(APIDurationDto::new).orElseThrow();
    }

    @Override
    public APIHorseGaitDurationDto getGaits() {
        return new APIHorseGaitDurationDtoImpl(this.horseCurrentRideAccessor);
    }

    @Override
    public APIPlayerDto getPlayer() {
        return this.horseCurrentRideAccessor.getPlayer().map(ECPlayer::getCorePlayer).map(APIPlayerDtoImpl::new).orElse(null);
    }
}

