/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ride;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseGaitDurationValueDto;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.ride.HorseCurrentRideAccessor;
import groovy.lang.Closure;
import java.time.Duration;
import java.util.Optional;

public class APIHorseGaitDurationValueDtoImpl
implements APIHorseGaitDurationValueDto {
    private final HorseSubGait gait;
    private final HorseCurrentRideAccessor horseCurrentRideAccessor;

    public APIHorseGaitDurationValueDtoImpl(HorseSubGait gait, HorseCurrentRideAccessor horseCurrentRideAccessor) {
        this.gait = gait;
        this.horseCurrentRideAccessor = horseCurrentRideAccessor;
    }

    @Override
    public APIDurationDto getDuration() {
        Optional<Duration> duration = this.horseCurrentRideAccessor.getDurationAtGait(this.gait);
        return duration.map(APIDurationDto::new).orElseThrow();
    }

    @Override
    public APIDurationDto getDuration(Closure<?> closure) {
        APIDurationDto duration = new APIDurationDto();
        closure.setDelegate(duration);
        closure.call();
        Optional<Duration> gaitDuration = this.horseCurrentRideAccessor.getDurationAtGaitInPastDuration(this.gait, duration.getDuration());
        return gaitDuration.map(APIDurationDto::new).orElseThrow();
    }

    @Override
    public APIDurationDto duration(Closure<?> closure) {
        return this.getDuration(closure);
    }
}

