/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ride;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.ride.HorseGaitTimes;
import com.equestricraft.core.horse.ride.HorseRideSpeedTimeBlock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class HorseCurrentRide {
    private final Date startTime = new Date();
    private final List<HorseRideSpeedTimeBlock> timeBlocks = new ArrayList<HorseRideSpeedTimeBlock>(0);

    public void startNewTimeBlock(HorseSubGait gait) {
        Date timeNow = new Date();
        Optional<HorseRideSpeedTimeBlock> current = this.getCurrentTimeBlock();
        current.ifPresent(timeBlock -> timeBlock.setEndTime(timeNow));
        HorseRideSpeedTimeBlock newTimeBlock = new HorseRideSpeedTimeBlock(gait, timeNow);
        this.timeBlocks.add(newTimeBlock);
    }

    public Optional<HorseRideSpeedTimeBlock> getCurrentTimeBlock() {
        if (this.timeBlocks.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.timeBlocks.get(this.timeBlocks.size() - 1));
    }

    public List<HorseRideSpeedTimeBlock> getTimeBlocks() {
        return this.timeBlocks;
    }

    public List<HorseRideSpeedTimeBlock> getTimeBlocksForGait(HorseSubGait gait) {
        return this.getTimeBlocks().stream().filter(t -> {
            if (gait != null) {
                return t.getGait() == gait;
            }
            return t.getGait() != Halt.DEFAULT;
        }).toList();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Duration getDuration() {
        return DateUtils.durationSince(this.startTime);
    }

    public HorseGaitTimes getGaitTimes() {
        HorseGaitTimes gaitTimes = new HorseGaitTimes();
        for (HorseRideSpeedTimeBlock timeBlock : this.getTimeBlocks()) {
            Duration currentDuration = gaitTimes.get(timeBlock.getGait());
            if (currentDuration == null) {
                gaitTimes.put(timeBlock.getGait(), timeBlock.getDuration());
                continue;
            }
            Duration newDuration = currentDuration.plus(timeBlock.getDuration());
            gaitTimes.put(timeBlock.getGait(), newDuration);
        }
        return gaitTimes;
    }
}

