/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ride;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.ride.HorseCurrentRide;
import com.equestricraft.core.horse.ride.HorseRideSpeedTimeBlock;
import com.equestricraft.core.player.ECPlayer;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class HorseCurrentRideAccessor
extends AbstractHorseAccessor {
    private HorseCurrentRide currentRide = null;
    private ECPlayer player = null;

    public HorseCurrentRideAccessor(EQHorse horse) {
        super(horse);
    }

    public void startRide() {
        this.currentRide = new HorseCurrentRide();
    }

    public HorseCurrentRide getCurrentRide() {
        return this.currentRide;
    }

    public boolean hasCurrentRide() {
        return this.currentRide != null;
    }

    public Optional<Date> getStartTimeOfRide() {
        return Optional.ofNullable(this.currentRide.getStartTime());
    }

    public Optional<Duration> getTotalDurationOfRide() {
        return Optional.ofNullable(this.currentRide.getDuration());
    }

    public Optional<Duration> getDurationAtGait(HorseSubGait gait) {
        if (this.currentRide == null) {
            return Optional.empty();
        }
        List<HorseRideSpeedTimeBlock> timeBlocks = this.currentRide.getTimeBlocksForGait(gait);
        Duration duration = timeBlocks.stream().map(HorseRideSpeedTimeBlock::getDuration).reduce(Duration::plus).orElse(Duration.ZERO);
        return Optional.of(duration);
    }

    public Optional<Duration> getDurationAtGaitInPastDuration(HorseSubGait gait, Duration duration) {
        if (this.currentRide == null) {
            return Optional.empty();
        }
        Date earliestDate = DateUtils.futureDurationOffset(duration.negated());
        List<HorseRideSpeedTimeBlock> timeBlocks = this.currentRide.getTimeBlocksForGait(gait);
        Duration d = timeBlocks.stream().filter(t -> t.getEndTime() == null || !t.getEndTime().before(earliestDate)).map(t -> {
            if (t.getStartTime().before(earliestDate)) {
                return new HorseRideSpeedTimeBlock(gait, earliestDate, t.getEndTime());
            }
            return t;
        }).map(HorseRideSpeedTimeBlock::getDuration).reduce(Duration::plus).orElse(Duration.ZERO);
        return Optional.of(d);
    }

    public Optional<ECPlayer> getPlayer() {
        return Optional.ofNullable(this.player);
    }

    public void setPlayer(ECPlayer player) {
        this.player = player;
    }

    public void clear() {
        this.currentRide = null;
        this.player = null;
    }
}

