/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ride;

import com.equestricraft.core.horse.ride.PlayerRideRecord;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;

public class HorseRideCache {
    private final Map<Integer, PlayerRideRecord> recordMap = new HashMap<Integer, PlayerRideRecord>();
    private final StampedLock lock = new StampedLock();
    private static final HorseRideCache instance = new HorseRideCache();

    private HorseRideCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRideRecord(int playerId, PlayerRideRecord playerRideRecord) {
        long stamp = this.lock.writeLock();
        try {
            this.recordMap.put(playerId, playerRideRecord);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerRideRecord getRideRecord(int playerId) {
        long stamp = this.lock.readLock();
        try {
            PlayerRideRecord playerRideRecord = this.recordMap.get(playerId);
            return playerRideRecord;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRideRecord(int playerId) {
        long stamp = this.lock.writeLock();
        try {
            this.recordMap.remove(playerId);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public static HorseRideCache getInstance() {
        return instance;
    }
}

