/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ride;

import com.equestricraft.core.horse.gait.HorseSubGait;
import java.time.Duration;
import java.util.Date;

public class HorseRideSpeedTimeBlock {
    private final HorseSubGait gait;
    private final Date startTime;
    private Date endTime = null;

    public HorseRideSpeedTimeBlock(HorseSubGait gait, Date startTime) {
        this.gait = gait;
        this.startTime = startTime;
    }

    public HorseRideSpeedTimeBlock(HorseSubGait gait, Date startTime, Date endTime) {
        this(gait, startTime);
        this.endTime = endTime;
    }

    public HorseSubGait getGait() {
        return this.gait;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Duration getDuration() {
        long millis = (this.endTime != null ? this.endTime.getTime() : System.currentTimeMillis()) - this.startTime.getTime();
        return Duration.ofMillis(millis);
    }
}

