/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ridelog;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseRideTimeSearchDto;
import com.equestricraft.api.common.APIPlayerDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.Range;
import com.equestricraft.core.horse.ridelog.HorseRideTimeAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerTransformer;
import java.time.Duration;
import java.util.Date;

public class APIHorseRideTimeSearchDtoImpl
implements APIHorseRideTimeSearchDto {
    private final HorseRideTimeAccessor horseRideTimeAccessor;
    private APIPlayerDto player = null;
    private Date startTime = null;
    private Date endTime = null;
    @Service
    private static PlayerTransformer playerTransformer;

    public APIHorseRideTimeSearchDtoImpl(HorseRideTimeAccessor horseRideTimeAccessor) {
        this.horseRideTimeAccessor = horseRideTimeAccessor;
    }

    @Override
    public APIHorseRideTimeSearchDto player(APIPlayerDto player) {
        this.player = player;
        return this;
    }

    @Override
    public APIHorseRideTimeSearchDto startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @Override
    public APIHorseRideTimeSearchDto endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @Override
    public APIDurationDto getDuration() {
        if (this.player != null) {
            CorePlayer p = playerTransformer.fromDto(this.player);
            Duration duration = this.horseRideTimeAccessor.getRideTimeWithPlayer(p, Range.of(this.startTime, this.endTime));
            return new APIDurationDto(duration);
        }
        Duration duration = this.horseRideTimeAccessor.getTotalRideTime(Range.of(this.startTime, this.endTime));
        return new APIDurationDto(duration);
    }

    public String toString() {
        return this.getDuration().toString();
    }
}

