/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ridelog;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.ridelog.HorseRideLog;
import java.util.List;

public class HorseRideLogDatabase
implements RepositoryDatasource<HorseRideLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_START_TIME = "START_TIME";
    private static final String COLUMN_END_TIME = "END_TIME";

    @Override
    public void create(HorseRideLog horseRideLog) {
        Query.insertInto("HORSE_RIDE_LOG").columns(QueryColumn.column(COLUMN_HORSE_ID, horseRideLog.getHorseId()), QueryColumn.column(COLUMN_PLAYER_ID, horseRideLog.getPlayerId()), QueryColumn.column(COLUMN_START_TIME, horseRideLog.getStartTime()), QueryColumn.column(COLUMN_END_TIME, horseRideLog.getEndTime())).executeGetGeneratedKey(horseRideLog::setId);
    }

    @Override
    public List<HorseRideLog> retrieveAll() {
        return Query.selectAllFrom("HORSE_RIDE_LOG").getList(this::getFromResultRow);
    }

    private HorseRideLog getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long startTime = row.getLong(COLUMN_START_TIME);
        long endTime = row.getLong(COLUMN_END_TIME);
        return new HorseRideLog(id, horseId, playerId, startTime, endTime);
    }
}

