/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ridelog;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.ridelog.HorseRideLog;
import com.equestricraft.core.horse.ridelog.HorseRideLogDatabase;
import java.util.Date;
import java.util.List;
import java.util.function.Function;

public class HorseRideLogRepository
extends Repository<HorseRideLog, Integer> {
    @Service
    private HorseRideLogDatabase horseRideLogDatabase;

    @Override
    protected RepositoryDatasource<HorseRideLog, Integer> getDatasource() {
        return this.horseRideLogDatabase;
    }

    @Override
    protected Function<HorseRideLog, Object> getIndexFunction() {
        return HorseRideLog::getHorseId;
    }

    public List<HorseRideLog> findAllRideLogsByHorse(int horseId) {
        return this.findListByIndexKey(horseId);
    }

    public List<HorseRideLog> findAllRideLogsByHorse(int horseId, Date start, Date end) {
        RepositorySearchQuery<HorseRideLog> query = this.createSearchQuery();
        query.filter(hrl -> hrl.getHorseId() == horseId);
        this.dateFilter(query, start, end);
        return query.many();
    }

    public List<HorseRideLog> findAllRideLogsByPlayer(int playerId) {
        return this.findListByPredicates((T hrl) -> hrl.getPlayerId() == playerId);
    }

    public List<HorseRideLog> findAllRideLogsByPlayer(int playerId, Date start, Date end) {
        RepositorySearchQuery<HorseRideLog> query = this.createSearchQuery();
        query.filter(hrl -> hrl.getPlayerId() == playerId);
        this.dateFilter(query, start, end);
        return query.many();
    }

    public List<HorseRideLog> findAllRideLogsByHorseAndPlayer(int horseId, int playerId) {
        return this.findListByPredicates(hrl -> hrl.getHorseId() == horseId, hrl -> hrl.getPlayerId() == playerId);
    }

    public List<HorseRideLog> findAllRideLogsByHorseAndPlayer(int horseId, int playerId, Date start, Date end) {
        RepositorySearchQuery<HorseRideLog> query = this.createSearchQuery();
        query.filter(hrl -> hrl.getHorseId() == horseId);
        query.filter(hrl -> hrl.getPlayerId() == playerId);
        this.dateFilter(query, start, end);
        return query.many();
    }

    private void dateFilter(RepositorySearchQuery<HorseRideLog> query, Date start, Date end) {
        if (start != null) {
            query.filter(hrl -> hrl.getEndTime() >= start.getTime());
        }
        if (end != null) {
            query.filter(hrl -> hrl.getStartTime() <= end.getTime());
        }
    }
}

