/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ridelog;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.ridelog.HorseRideLog;
import com.equestricraft.core.horse.ridelog.HorseRideLogRepository;
import com.equestricraft.core.horse.ridelog.HorseRideLogSession;
import com.equestricraft.core.player.ECPlayer;
import java.time.Duration;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class HorseRideLogSessionImpl
implements HorseRideLogSession {
    @Service
    private HorseRideLogRepository horseRideLogRepository;

    @Override
    public void logHorseRide(EQHorse horse, ECPlayer player, Date startTime, Date endTime) {
        HorseRideLog newLog = new HorseRideLog(0, horse.getId(), player.getId(), startTime.getTime(), endTime.getTime());
        this.horseRideLogRepository.add(newLog);
    }

    @Override
    public Duration getHorsesTotalRideTime(int horseId) {
        return this.getHorsesTotalRideTime(horseId, null, null);
    }

    @Override
    public Duration getHorsesTotalRideTime(int horseId, Date start, Date end) {
        List<HorseRideLog> horseLogs = this.horseRideLogRepository.findAllRideLogsByHorse(horseId, start, end);
        return this.countTotalDurationForLogs(horseLogs, start, end);
    }

    @Override
    public Duration getPlayersTotalRideTime(ECPlayer player) {
        return this.getPlayersTotalRideTime(player, null, null);
    }

    @Override
    public Duration getPlayersTotalRideTime(ECPlayer player, Date start, Date end) {
        List<HorseRideLog> playerLogs = this.horseRideLogRepository.findAllRideLogsByPlayer(player.getId(), start, end);
        return this.countTotalDurationForLogs(playerLogs, start, end);
    }

    @Override
    public Duration getHorsesTotalRideTimeWithPlayer(int horseId, ECPlayer player) {
        return this.getHorsesTotalRideTimeWithPlayer(horseId, player, null, null);
    }

    @Override
    public Duration getHorsesTotalRideTimeWithPlayer(int horseId, ECPlayer player, Date start, Date end) {
        List<HorseRideLog> logs = this.horseRideLogRepository.findAllRideLogsByHorseAndPlayer(horseId, player.getId(), start, end);
        return this.countTotalDurationForLogs(logs, start, end);
    }

    private Duration countTotalDurationForLogs(List<HorseRideLog> logs, Date start, Date end) {
        long totalMillis = logs.stream().mapToLong(l -> this.calculateLogDurationWithinLimits((HorseRideLog)l, start, end)).sum();
        return Duration.ofMillis(totalMillis);
    }

    private long calculateLogDurationWithinLimits(HorseRideLog log, Date start, Date end) {
        long startToUse = start != null ? Math.max(log.getStartTime(), start.getTime()) : log.getStartTime();
        long endToUse = end != null ? Math.max(log.getEndTime(), end.getTime()) : log.getEndTime();
        return endToUse - startToUse;
    }

    @Override
    public Optional<Date> getHorsesLastRideTime(int horseId) {
        List<HorseRideLog> horseLogs = this.horseRideLogRepository.findAllRideLogsByHorse(horseId);
        return this.getMostRecentEndDate(horseLogs);
    }

    @Override
    public Optional<Date> getPlayersLastRideTime(ECPlayer player) {
        List<HorseRideLog> playerLogs = this.horseRideLogRepository.findAllRideLogsByPlayer(player.getId());
        return this.getMostRecentEndDate(playerLogs);
    }

    @Override
    public Optional<Date> getHorsesLastRideTimeWithPlayer(int horseId, ECPlayer player) {
        List<HorseRideLog> logs = this.horseRideLogRepository.findAllRideLogsByHorseAndPlayer(horseId, player.getId());
        return this.getMostRecentEndDate(logs);
    }

    private Optional<Date> getMostRecentEndDate(List<HorseRideLog> logs) {
        return logs.stream().max(Comparator.comparingLong(HorseRideLog::getStartTime)).map(HorseRideLog::getEndTime).map(Date::new);
    }
}

