/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.ridelog;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.Range;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.ridelog.HorseRideLogSession;
import com.equestricraft.core.player.ECPlayer;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;

public class HorseRideTimeAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseRideLogSession horseRideLogSession;

    public HorseRideTimeAccessor(EQHorse horse) {
        super(horse);
    }

    public Duration getRideTimeWithPlayer(ECPlayer player) {
        return horseRideLogSession.getHorsesTotalRideTimeWithPlayer(this.horse.getId(), player);
    }

    public Duration getRideTimeWithPlayer(ECPlayer player, Range<Date> dateRange) {
        return horseRideLogSession.getHorsesTotalRideTimeWithPlayer(this.horse.getId(), player, dateRange.getLowerBound(), dateRange.getUpperBound());
    }

    public Optional<Date> getLastRideTimeWithPlayer(ECPlayer player) {
        return horseRideLogSession.getHorsesLastRideTimeWithPlayer(this.horse.getId(), player);
    }

    public Duration getTotalRideTime() {
        return horseRideLogSession.getHorsesTotalRideTime(this.horse.getId());
    }

    public Duration getTotalRideTime(Range<Date> dateRange) {
        return horseRideLogSession.getHorsesTotalRideTime(this.horse.getId(), dateRange.getLowerBound(), dateRange.getUpperBound());
    }

    public Optional<Date> getLastRideTime() {
        return horseRideLogSession.getHorsesLastRideTime(this.horse.getId());
    }
}

