/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.sale;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.DualAccountEconomyResponse;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseTransferCommand;
import com.equestricraft.core.horse.pregnancy.PregnancyInfo;
import com.equestricraft.core.horse.pregnancy.PregnancySession;
import com.equestricraft.core.horse.sale.HorseSaleResponse;
import com.equestricraft.core.horse.sale.HorseSellException;
import com.equestricraft.core.horse.sale.HorseSellSession;
import com.equestricraft.core.horse.sale.PreSaleInfo;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.core.player.PlayerTransformer;

public class HorseSellSessionImpl
implements HorseSellSession {
    @Service
    private PregnancySession pregnancySession;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public HorseSaleResponse sellHorse(EQHorse horse, ECPlayer newOwner) throws HorseSellException {
        ECPlayer currentOwner = horse.getOwner();
        if (currentOwner.equals(newOwner)) {
            throw new HorseSellException(I18n.getLabel("horse.sell.cannot-sell-to-yourself"));
        }
        if (!horse.isOwnedByPlayer()) {
            throw new HorseSellException(I18n.getLabel("horse.sell.horse-not-owned"));
        }
        try {
            double value = horse.getCurrentValue();
            DualAccountEconomyResponse response = newOwner.getEconomy().sendTo(currentOwner, value, I18n.getLabel("horse.sell.transaction-line"));
            horse.getCommandExecutor().execute(new HorseTransferCommand(currentOwner, newOwner, value));
            return new HorseSaleResponse(value, response.toAccountBalance(), response.fromAccountBalance());
        }
        catch (EconomyException ex) {
            throw new HorseSellException(ex.getMessage());
        }
    }

    @Override
    public PreSaleInfo getPreSaleInformation(EQHorse horse) {
        PlayerSimple foalOwner = this.pregnancySession.retrievePregnancyInfoForHorse(horse.getId()).map(PregnancyInfo::foalOwner).map(ECPlayer::getCorePlayer).map(this.playerTransformer::toSimple).orElse(null);
        String breed = horse.getBreed().getDisplayString();
        return PreSaleInfo.build(horse.getId()).withShowName(horse.getShowName()).withValue(EconomyUtilities.formatCurrency(horse.getCurrentValue())).withPregnancy(foalOwner).withHealth(horse.getHealth().getStatus()).withAgeDisplay(horse.getAge().getDisplayString()).withStudRegistrationStatus(horse.getStudRegistration().getStatus()).withSellingPlayerIgn(this.playerTransformer.toSimple(horse.getOwner().getCorePlayer())).withBreed(breed).complete();
    }
}

