/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.sale;

import com.equestricraft.core.horse.health.HorseHealth;
import com.equestricraft.core.horse.stud.StudRegistrationStatus;
import com.equestricraft.core.player.PlayerSimple;

public record PreSaleInfo(int horseId, String showName, String value, boolean pregnant, PlayerSimple foalOwner, HorseHealth health, String ageDisplay, StudRegistrationStatus studRegistrationStatus, PlayerSimple sellingPlayer, String breed) {
    public static Builder build(int horseId) {
        return new Builder(horseId);
    }

    public static class Builder {
        private final int horseId;
        private String showName;
        private String value = null;
        private boolean pregnant = false;
        private PlayerSimple foalOwner = null;
        private HorseHealth healthy = null;
        private String ageDisplay = null;
        private StudRegistrationStatus studRegistrationStatus = null;
        private PlayerSimple sellingPlayer = null;
        private String breed = null;

        private Builder(int horseId) {
            this.horseId = horseId;
        }

        public Builder withShowName(String showName) {
            this.showName = showName;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withPregnancy(PlayerSimple foalOwner) {
            this.pregnant = foalOwner != null;
            this.foalOwner = foalOwner;
            return this;
        }

        public Builder withHealth(HorseHealth health) {
            this.healthy = health;
            return this;
        }

        public Builder withAgeDisplay(String ageDisplay) {
            this.ageDisplay = ageDisplay;
            return this;
        }

        public Builder withStudRegistrationStatus(StudRegistrationStatus studRegistrationStatus) {
            this.studRegistrationStatus = studRegistrationStatus;
            return this;
        }

        public Builder withSellingPlayerIgn(PlayerSimple sellingPlayer) {
            this.sellingPlayer = sellingPlayer;
            return this;
        }

        public Builder withBreed(String breed) {
            this.breed = breed;
            return this;
        }

        public PreSaleInfo complete() {
            return new PreSaleInfo(this.horseId, this.showName, this.value, this.pregnant, this.foalOwner, this.healthy, this.ageDisplay, this.studRegistrationStatus, this.sellingPlayer, this.breed);
        }
    }
}

