/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.sale.log;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.sale.log.HorseSaleLog;
import java.util.List;

public class HorseSaleLogDatabase
implements RepositoryDatasource<HorseSaleLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_SALE_VALUE = "SALE_VALUE";

    @Override
    public void create(HorseSaleLog horseSaleLog) {
        Query.insertInto("HORSE_SALE_LOG").columns(QueryColumn.column(COLUMN_HORSE_ID, horseSaleLog.getHorseId()), QueryColumn.column(COLUMN_PLAYER_ID, horseSaleLog.getPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, horseSaleLog.getTimeStamp()), QueryColumn.column(COLUMN_SALE_VALUE, horseSaleLog.getSaleValue())).executeGetGeneratedKey(horseSaleLog::setId);
    }

    @Override
    public List<HorseSaleLog> retrieveAll() {
        return Query.selectAllFrom("HORSE_SALE_LOG").getList(this::getFromResultRow);
    }

    private HorseSaleLog getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        Double saleValue = row.getNullableDouble(COLUMN_SALE_VALUE);
        return new HorseSaleLog(id, horseId, playerId, timeStamp, saleValue);
    }
}

