/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.sale.log;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.horse.sale.log.HorseSaleInfo;
import com.equestricraft.core.horse.sale.log.HorseSaleLog;
import com.equestricraft.core.horse.sale.log.HorseSaleLogRepository;
import com.equestricraft.core.horse.sale.log.HorseSalePage;
import com.equestricraft.core.horse.sale.log.HorseSalePaginationSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.Comparator;
import java.util.List;

public class HorseSalePaginationSessionImpl
extends Pagination<HorseSaleInfo, HorseSalePage, Object, Object>
implements HorseSalePaginationSession {
    @Service
    private HorseSaleLogRepository horseSaleLogRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public HorseSalePage retrieveHorseSalePage(int horseId, int pageNumber, SortDirection sortDirection) {
        List<HorseSaleLog> logsForHorse = this.horseSaleLogRepository.findByHorse(horseId);
        List<HorseSaleInfo> infoList = this.toInfoList(logsForHorse);
        return (HorseSalePage)this.paginate(infoList, pageNumber, sortDirection, null, null);
    }

    private List<HorseSaleInfo> toInfoList(List<HorseSaleLog> horseSaleLogs) {
        return horseSaleLogs.stream().map(this::buildInfo).toList();
    }

    private HorseSaleInfo buildInfo(HorseSaleLog log) {
        CorePlayer player = (CorePlayer)this.playerRepository.findByKey(log.getPlayerId());
        String value = log.getSaleValue() != null ? EconomyUtilities.formatCurrency(log.getSaleValue()) : "---";
        return new HorseSaleInfo(log.getId(), this.playerTransformer.toSimple(player), log.getTimeStamp(), value);
    }

    @Override
    protected int getMaximumPerPage() {
        return 10;
    }

    @Override
    protected boolean filter(HorseSaleInfo item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<HorseSaleInfo> compare(Object sortOrderObject) {
        return Comparator.comparingLong(HorseSaleInfo::timeStamp).reversed();
    }

    @Override
    protected HorseSalePage buildPage(List<HorseSaleInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new HorseSalePage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

