/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.shoe;

import com.equestricraft.api.common.APIHorseShoeDto;
import com.equestricraft.api.common.APIHorseShoesDto;
import com.equestricraft.api.common.APIShoeDto;
import com.equestricraft.core.horse.shoe.APIHorseShoeDtoImpl;
import com.equestricraft.core.horse.shoe.HorseShoeAccessor;
import com.equestricraft.core.horse.shoe.HorseShoeException;
import com.equestricraft.core.shoe.APIShoeDtoImpl;
import com.equestricraft.core.shoe.HorseShoe;

public class APIHorseShoesDtoImpl
implements APIHorseShoesDto {
    private final HorseShoeAccessor horseShoeAccessor;

    public APIHorseShoesDtoImpl(HorseShoeAccessor horseShoeAccessor) {
        this.horseShoeAccessor = horseShoeAccessor;
    }

    @Override
    public void set(APIShoeDto shoe) {
        HorseShoe s = ((APIShoeDtoImpl)shoe).getShoe();
        try {
            this.horseShoeAccessor.setShoe(s);
        }
        catch (HorseShoeException horseShoeException) {
            // empty catch block
        }
    }

    @Override
    public APIHorseShoeDto getCurrent() {
        return this.horseShoeAccessor.getShoe().map(s -> new APIHorseShoeDtoImpl((HorseShoe)s, this.horseShoeAccessor)).orElse(null);
    }

    @Override
    public void repair() {
        try {
            this.horseShoeAccessor.repairShoe();
        }
        catch (HorseShoeException horseShoeException) {
            // empty catch block
        }
    }

    @Override
    public void remove() {
        try {
            this.horseShoeAccessor.removeShoe();
        }
        catch (HorseShoeException horseShoeException) {
            // empty catch block
        }
    }

    @Override
    public void removeShoeFromOneHoof() {
        this.horseShoeAccessor.removeOneShoe();
    }
}

