/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.shoe;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.hoof.GroundType;
import com.equestricraft.core.horse.shoe.HorseShoeException;
import com.equestricraft.core.horse.shoe.HorseShoeFitAction;
import com.equestricraft.core.horse.shoe.HorseShoeRemoveAction;
import com.equestricraft.core.horse.shoe.ShoeInformation;
import com.equestricraft.core.shoe.HorseShoe;
import com.equestricraft.core.shoe.TractionPercentage;
import com.equestricraft.featureflag.FeatureFlag;
import java.util.Optional;

public class HorseShoeAccessor
extends AbstractHorseAccessor {
    public HorseShoeAccessor(EQHorse horse) {
        super(horse);
    }

    public void setShoe(HorseShoe shoe) throws HorseShoeException {
        if (this.horse.getHorseShoe() != null) {
            throw new HorseShoeException(I18n.getLabel("horse-shoe.has-shoe-on-already"));
        }
        this.horse.getActions().processAction(new HorseShoeFitAction(this.horse, shoe));
    }

    public Optional<HorseShoe> getShoe() {
        if (this.horse.getHorseShoe() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.horse.getHorseShoe().getShoe());
    }

    public Optional<Double> getEffectivenessPercentage() {
        Optional<HorseShoe> shoe = this.getShoe();
        if (shoe.isPresent()) {
            float effectiveness = this.calculateShoeEffectiveness(shoe.get());
            return Optional.of((double)effectiveness * 100.0);
        }
        return Optional.empty();
    }

    public void repairShoe() throws HorseShoeException {
        Optional<HorseShoe> shoe = this.horse.getShoes().getShoe();
        if (shoe.isEmpty()) {
            throw new HorseShoeException(I18n.getLabel("horse-shoe.no-shoes-on"));
        }
        this.horse.getHorseShoe().setShoeEndTime(shoe.get().getMaximumEndTimeForShoeFromNow().getTime());
        this.horse.save();
    }

    public void removeShoe() throws HorseShoeException {
        if (this.horse.getHorseShoe() == null) {
            throw new HorseShoeException(I18n.getLabel("horse-shoe.no-shoes-on"));
        }
        this.horse.getActions().processAction(new HorseShoeRemoveAction(this.horse));
    }

    public Optional<ShoeInformation> getInformationAboutShoe() {
        Optional<HorseShoe> shoe = this.horse.getShoes().getShoe();
        if (shoe.isEmpty()) {
            return Optional.empty();
        }
        HorseShoe s = shoe.get();
        double percentage = (double)this.calculateShoeEffectiveness(s) * 100.0;
        ShoeInformation info2 = new ShoeInformation(s.getId(), s.getName(), percentage, this.horse.getHorseShoe().hasMissingShoe());
        return Optional.of(info2);
    }

    public void removeOneShoe() {
        if (FeatureFlag.SHOES_FALLING_OFF.isDisabled()) {
            return;
        }
        if (this.horse.getHorseShoe() == null) {
            return;
        }
        int count = this.horse.getHorseShoe().getFittedShoeCount();
        if (count > 0) {
            this.horse.getHorseShoe().setFittedShoeCount(count - 1);
            this.horse.save();
        }
    }

    public float getMaximumStaminaOffsetFactor() {
        Optional<HorseShoe> shoe = this.horse.getShoes().getShoe();
        if (shoe.isEmpty()) {
            return 1.0f;
        }
        HorseShoe s = shoe.get();
        float effectiveness = this.calculateShoeEffectiveness(s);
        return (float)(s.getMaximumStaminaOffsetPercentage() / 100.0 * (double)effectiveness);
    }

    public long getStaminaOffsetPerTickOffset() {
        Optional<HorseShoe> shoe = this.horse.getShoes().getShoe();
        if (shoe.isEmpty()) {
            return 0L;
        }
        HorseShoe s = shoe.get();
        float effectiveness = this.calculateShoeEffectiveness(s);
        return (long)((float)s.getStaminaOffsetPerTickOffset() * effectiveness);
    }

    public double getHoofWearReductionPercentage() {
        Optional<HorseShoe> shoe = this.horse.getShoes().getShoe();
        if (shoe.isEmpty()) {
            return 0.0;
        }
        HorseShoe s = shoe.get();
        float effectiveness = this.calculateShoeEffectiveness(s);
        return s.getHoofWearReductionPercentage() * (double)effectiveness;
    }

    public double getSpeedPercentageEffect() {
        Optional<HorseShoe> shoe = this.horse.getShoes().getShoe();
        if (shoe.isEmpty()) {
            return 100.0;
        }
        float effectiveness = this.calculateShoeEffectiveness(shoe.get());
        if (this.horse.getHorseShoe().getFittedShoeCount() == 0) {
            return 100.0;
        }
        return shoe.get().getSpeedOffsetPercentage() * (double)effectiveness;
    }

    public float getTractionValue(GroundType groundType) {
        Optional<HorseShoe> shoe = this.horse.getShoes().getShoe();
        if (shoe.isEmpty()) {
            return 1.0f;
        }
        HorseShoe s = shoe.get();
        double percentage = this.getPercentage(s.getTractionPercentage(), groundType);
        float value = PercentageUtils.of(1.0f, percentage);
        float effectiveness = this.calculateShoeEffectiveness(s);
        return value * effectiveness;
    }

    private double getPercentage(TractionPercentage tractionPercentage, GroundType groundType) {
        return switch (groundType) {
            default -> throw new IncompatibleClassChangeError();
            case GroundType.HARD -> tractionPercentage.getHard();
            case GroundType.SOFT -> tractionPercentage.getSoft();
            case GroundType.LOOSE -> tractionPercentage.getLoose();
        };
    }

    private float calculateShoeEffectiveness(HorseShoe shoe) {
        long totalShoeDuration = (long)shoe.getDurationDays() * 86400000L;
        long millisLeft = DateUtils.millisUntil(this.horse.getHorseShoe().getShoeEndTime());
        return (float)((double)millisLeft / (double)totalShoeDuration);
    }
}

