/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.shoe;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.horse.shoe.HorseShoeHorse;
import java.util.Optional;

public class HorseShoeHorseDatabase {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_SHOE_ID = "SHOE_ID";
    private static final String COLUMN_SHOE_TIME = "SHOE_TIME";
    private static final String COLUMN_SHOE_END_TIME = "SHOE_END_TIME";
    private static final String COLUMN_FITTED_SHOE_COUNT = "FITTED_SHOE_COUNT";

    public void addHorseShoeHorse(int horseId, HorseShoeHorse horseShoeHorse) {
        Query.insertInto("HORSE_SHOE_HORSE").columns(QueryColumn.column(COLUMN_HORSE_ID, horseId), QueryColumn.column(COLUMN_SHOE_ID, horseShoeHorse.getShoeId()), QueryColumn.column(COLUMN_SHOE_TIME, horseShoeHorse.getShoeTime()), QueryColumn.column(COLUMN_SHOE_END_TIME, horseShoeHorse.getShoeEndTime()), QueryColumn.column(COLUMN_FITTED_SHOE_COUNT, horseShoeHorse.getFittedShoeCount())).onDuplicateKeyUpdate("SHOE_END_TIME = VALUES(SHOE_END_TIME)", "FITTED_SHOE_COUNT = VALUES(FITTED_SHOE_COUNT)").execute();
    }

    public Optional<HorseShoeHorse> getShoeForHorse(int horseId) {
        return Query.selectAllFrom("HORSE_SHOE_HORSE").where(QueryColumn.column(COLUMN_HORSE_ID, horseId)).getSingle(this::getFromResultRow);
    }

    private HorseShoeHorse getFromResultRow(ResultRow row) {
        int shoeId = row.getInt(COLUMN_SHOE_ID);
        long shoeTime = row.getLong(COLUMN_SHOE_TIME);
        long shoeEndTime = row.getLong(COLUMN_SHOE_END_TIME);
        int fittedShoeCount = row.getInt(COLUMN_FITTED_SHOE_COUNT);
        return new HorseShoeHorse(shoeId, shoeTime, shoeEndTime, fittedShoeCount);
    }

    public void removeShoeForHorse(int horseId) {
        Query.deleteFrom("HORSE_SHOE_HORSE").where(QueryColumn.column(COLUMN_HORSE_ID, horseId)).execute();
    }
}

