/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.spay;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSpayedException;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;

public class HorseSpayAccessor
extends AbstractHorseAccessor {
    public HorseSpayAccessor(EQHorse horse) {
        super(horse);
    }

    public boolean isSpayed() {
        return this.horse.getSpayedTime() != null;
    }

    public void spay() throws HorseSpayedException {
        if (this.isSpayed()) {
            throw new HorseSpayedException();
        }
        this.horse.setSpayedTime(new Date());
        this.horse.save();
    }

    public Optional<Duration> getDurationSinceSpayed() {
        Date date = this.horse.getSpayedTime();
        if (date == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(DateUtils.durationSince(date));
    }
}

