/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.speed;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.HorseGaitCache;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.stats.HorseStat;
import com.equestricraft.core.horse.stats.HorseStatsSession;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class HorseSpeedAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseStatsSession horseStatsSession;
    private static final HorseGaitCache horseGaitCache;
    private final CachedValue<Map<Float, HorseStat>> statsForGaits = new CachedValue<Map>(this::getStatsForGaits, Duration.ofMinutes(1L));

    public HorseSpeedAccessor(EQHorse horse) {
        super(horse);
    }

    public HorseStat getStat(HorseSubGait gait) {
        return this.statsForGaits.get().get(Float.valueOf(gait.getBlocksPerSecond()));
    }

    public float getValue(HorseSubGait gait) {
        return this.getStat(gait).value();
    }

    public float getBaseValue(HorseSubGait gait) {
        return this.getStat(gait).baseValue();
    }

    public float getImpairmentFactor(HorseSubGait gait) {
        return this.getStat(gait).getImpairmentFactor();
    }

    private Map<Float, HorseStat> getStatsForGaits() {
        HashMap<Float, HorseStat> statsForGait = new HashMap<Float, HorseStat>();
        for (HorseSubGait gait : horseGaitCache.getAll()) {
            float blocksPerSecond = gait.getBlocksPerSecond();
            HorseStat stat = horseStatsSession.getHorsesSpeed(this.horse, blocksPerSecond);
            statsForGait.put(Float.valueOf(blocksPerSecond), stat);
        }
        return statsForGait;
    }

    static {
        horseGaitCache = HorseGaitCache.getInstance();
    }
}

