/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.spook;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.collector.ECCollectors;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.spook.SpookProvider;
import com.equestricraft.core.horse.trait.Trait;
import com.equestricraft.core.horse.trait.TraitVisitor;

public class SpookTrait
implements Trait {
    @Service
    private static ServiceInstance<SpookProvider> spookProviders;

    @Override
    public float getValue(EQHorse horse) {
        return spookProviders.stream().map(p -> Float.valueOf(p.getOffsetPercentage(horse))).collect(ECCollectors.toCombinedFloatPercentage(this.getCoreValue(horse))).floatValue();
    }

    private float getCoreValue(EQHorse horse) {
        float extra = (float)(Math.min(horse.getAge().getYears() / 2.0, 1.0) / 2.0);
        return 0.5f + extra;
    }

    @Override
    public String getName() {
        return I18n.getLabel("horse.trait.spook.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("horse.trait.spook.description");
    }

    @Override
    public <T> T accept(TraitVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

