/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.stallrest;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;

public class HorseStallRestAccessor
extends AbstractHorseAccessor {
    public HorseStallRestAccessor(EQHorse horse) {
        super(horse);
    }

    public Optional<Duration> getDurationSinceStart() {
        if (this.isActive()) {
            return Optional.ofNullable(DateUtils.durationSince(this.horse.getStallRestStart()));
        }
        return Optional.empty();
    }

    public Optional<Duration> getDurationLeft() {
        Date stallRestEnd = this.horse.getStallRestEnd();
        if (stallRestEnd == null) {
            return Optional.empty();
        }
        if (DateUtils.isInPast(stallRestEnd)) {
            return Optional.empty();
        }
        return Optional.of(DateUtils.durationUntil(stallRestEnd));
    }

    public void setStallRestForDuration(Duration duration) {
        Date newStallRestEnd = DateUtils.futureDurationOffset(duration);
        Date currentStallRestEnd = this.horse.getStallRestEnd();
        if (currentStallRestEnd != null && currentStallRestEnd.after(newStallRestEnd)) {
            return;
        }
        this.horse.setStallRestStart(new Date());
        this.horse.setStallRestEnd(newStallRestEnd);
        this.horse.save();
    }

    public boolean isActive() {
        return this.getDurationLeft().isPresent();
    }

    public void end() {
        this.horse.setStallRestStart(null);
        this.horse.setStallRestEnd(null);
        this.horse.save();
    }
}

