/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.stamina;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.collector.ECCollectors;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.agesetting.AgeSettingSession;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.stamina.HorseMaximumStaminaSession;
import com.equestricraft.core.horse.stamina.HorseMaximumStaminaStatProvider;
import com.equestricraft.featureflag.FeatureFlag;

public class HorseMaximumStaminaSessionImpl
implements HorseMaximumStaminaSession {
    @Service
    private ServiceInstance<HorseMaximumStaminaStatProvider> horseMaximumStaminaStatProviders;
    @Service
    private AgeSettingSession ageSettingSession;

    @Override
    public long getMaximumStamina(EQHorse horse) {
        long maximum = horse.getBaseMaximumStamina().getValue().longValue();
        if (FeatureFlag.STAMINA.isEnabled()) {
            Float offset = this.horseMaximumStaminaStatProviders.stream().map(p -> Float.valueOf(p.getMaximumStaminaOffset(horse))).collect(ECCollectors.toCombinedFloatPercentage());
            maximum = (long)((float)maximum * offset.floatValue());
        }
        double agePercentage = this.ageSettingSession.getMaximumStaminaPercentage(horse);
        return Math.max(0L, PercentageUtils.of(maximum, agePercentage));
    }
}

