/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.stamina;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.HorseGaitCache;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.stamina.HorseMaximumStaminaSession;
import com.equestricraft.core.horse.stamina.HorseStaminaOffsetPerTickSession;
import com.equestricraft.featureflag.FeatureFlag;
import java.util.HashMap;
import java.util.Map;

public class HorseStaminaAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseMaximumStaminaSession horseMaximumStaminaSession;
    @Service
    private static HorseStaminaOffsetPerTickSession horseStaminaOffsetPerTickSession;
    private static final HorseGaitCache horseGaitCache;
    private final CachedValue<Map<Float, Long>> staminaOffsetPerGaitMap = new CachedValue<Map>(this::getOffsetPerGaits, 30);
    private Long value = null;

    public HorseStaminaAccessor(EQHorse horse) {
        super(horse);
    }

    @Override
    public void activeTick() {
        if (FeatureFlag.STAMINA.isEnabled()) {
            if (this.value == null) {
                this.value = this.getCurrentMaximum();
            }
            Long amount = this.staminaOffsetPerGaitMap.get().get(Float.valueOf(this.horse.getGait().getCurrentGait().getBlocksPerSecond()));
            long newValue = this.value + amount;
            this.value = NumberUtils.keepWithinRange(newValue, 0L, this.getCurrentMaximum());
        }
    }

    public long getPoints() {
        return this.value != null ? this.value : 0L;
    }

    public float getValue() {
        if (FeatureFlag.STAMINA.isDisabled()) {
            return 1.0f;
        }
        long points = this.getPoints();
        long maximumPoints = this.getCurrentMaximum();
        return (float)points / (float)maximumPoints;
    }

    public double getPercentage() {
        return (double)this.getValue() * 100.0;
    }

    public long getCurrentMaximum() {
        return horseMaximumStaminaSession.getMaximumStamina(this.horse);
    }

    public long getBaseMaximum() {
        return this.horse.getBaseMaximumStamina().getValue().longValue();
    }

    private Map<Float, Long> getOffsetPerGaits() {
        HashMap<Float, Long> map = new HashMap<Float, Long>();
        for (HorseSubGait gait : horseGaitCache.getAll()) {
            long gaitValue = horseStaminaOffsetPerTickSession.getStaminaOffsetPerTickForGait(this.horse, gait);
            map.put(Float.valueOf(gait.getBlocksPerSecond()), gaitValue);
        }
        return map;
    }

    static {
        horseGaitCache = HorseGaitCache.getInstance();
    }
}

