/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.stamina;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.stamina.HorseStaminaOffsetPerTickProvider;
import com.equestricraft.core.horse.stamina.HorseStaminaOffsetPerTickSession;

public class HorseStaminaOffsetPerTickSessionImpl
implements HorseStaminaOffsetPerTickSession {
    @Service
    private ServiceInstance<HorseStaminaOffsetPerTickProvider> staminaOffsetPerTickProviders;

    @Override
    public long getStaminaOffsetPerTickForGait(EQHorse horse, HorseSubGait gait) {
        int value = this.getStaminaOffsetPerTick(gait);
        long additional = this.staminaOffsetPerTickProviders.stream().mapToLong(p -> p.getStaminaOffsetPerTick(horse)).sum();
        return (long)value + additional;
    }

    private int getStaminaOffsetPerTick(HorseSubGait gait) {
        return (int)(-3.125 * (double)gait.getStaminaOffsetPerTick() + 10.0);
    }
}

