/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.stats;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.collector.ECCollectors;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.stats.HorseJumpStatProvider;
import com.equestricraft.core.horse.stats.HorseSpeedStatProvider;
import com.equestricraft.core.horse.stats.HorseStat;
import com.equestricraft.core.horse.stats.HorseStatsSession;
import com.equestricraft.featureflag.FeatureFlag;
import java.util.function.Predicate;

public class HorseStatsSessionImpl
implements HorseStatsSession {
    @Service
    private ServiceInstance<HorseSpeedStatProvider> horseSpeedStatProviders;
    @Service
    private ServiceInstance<HorseJumpStatProvider> horseJumpStatProviders;

    @Override
    public HorseStat getHorsesSpeed(EQHorse horse, float baseValue) {
        double heightMeters = horse.getHeight().getMeters();
        float factorOfBase = (float)(heightMeters / HorseSettings.getBaseSpeedHeight());
        baseValue *= factorOfBase;
        if (FeatureFlag.STAT_EFFECTS.isEnabled()) {
            baseValue = this.horseSpeedStatProviders.stream().filter(HorseSpeedStatProvider::isPermanentSpeedImpairment).map(p -> Float.valueOf(p.getSpeedOffsetFactor(horse))).collect(ECCollectors.toCombinedFloatPercentage(baseValue)).floatValue();
            Float currentMaximum = this.horseSpeedStatProviders.stream().filter(Predicate.not(HorseSpeedStatProvider::isPermanentSpeedImpairment)).map(p -> Float.valueOf(p.getSpeedOffsetFactor(horse))).collect(ECCollectors.toCombinedFloatPercentage(baseValue));
            return new HorseStat(baseValue, currentMaximum.floatValue());
        }
        return new HorseStat(baseValue, baseValue);
    }

    @Override
    public HorseStat getHorsesJump(EQHorse horse) {
        float baseValue = HorseSettings.getBaseJumpValue();
        if (FeatureFlag.STAT_EFFECTS.isEnabled()) {
            baseValue = this.horseJumpStatProviders.stream().filter(HorseJumpStatProvider::isPermanentJumpImpairment).map(p -> Float.valueOf(p.getJumpOffsetFactor(horse))).collect(ECCollectors.toCombinedFloatPercentage(baseValue)).floatValue();
            Float currentMaximum = this.horseJumpStatProviders.stream().filter(Predicate.not(HorseJumpStatProvider::isPermanentJumpImpairment)).map(p -> Float.valueOf(p.getJumpOffsetFactor(horse))).collect(ECCollectors.toCombinedFloatPercentage(baseValue));
            return new HorseStat(baseValue, currentMaximum.floatValue());
        }
        return new HorseStat(baseValue, baseValue);
    }
}

