/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.stud;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.stud.HorseStudRegisterPage;
import com.equestricraft.core.horse.stud.HorseStudRegisterPageService;
import com.equestricraft.core.horse.stud.HorseStudRegisterSortOrder;
import com.equestricraft.core.horse.stud.HorseStudRegistrationSession;
import com.equestricraft.core.horse.stud.StudRegisterEntry;
import java.util.Comparator;
import java.util.List;

public class HorseStudRegisterPageServiceImpl
extends Pagination<StudRegisterEntry, HorseStudRegisterPage, HorseStudRegisterSortOrder, Object>
implements HorseStudRegisterPageService {
    @Service
    private HorseStudRegistrationSession horseStudRegistrationSession;
    private static final int MAXIMUM_PER_PAGE = 8;

    @Override
    public HorseStudRegisterPage retrieveStudRegister(HorseStudRegisterSortOrder sortOrder, SortDirection sortDirection, int pageNumber) {
        List<StudRegisterEntry> entries = this.horseStudRegistrationSession.retrieveStudRegister();
        return (HorseStudRegisterPage)this.paginate(entries, pageNumber, sortDirection, sortOrder, null);
    }

    @Override
    protected int getMaximumPerPage() {
        return 8;
    }

    @Override
    protected boolean filter(StudRegisterEntry item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<StudRegisterEntry> compare(HorseStudRegisterSortOrder sortOrderObject) {
        return switch (sortOrderObject) {
            default -> throw new IncompatibleClassChangeError();
            case HorseStudRegisterSortOrder.INITIAL_REGISTRATION -> Comparator.comparing(StudRegisterEntry::timeInitiallyRegistered);
            case HorseStudRegisterSortOrder.LAST_RENEWAL -> Comparator.comparing(StudRegisterEntry::timeLastRenewed);
            case HorseStudRegisterSortOrder.EXPIRY -> Comparator.comparing(StudRegisterEntry::expiryTime);
        };
    }

    @Override
    protected HorseStudRegisterPage buildPage(List<StudRegisterEntry> items, int pageNumber, int totalPages, SortDirection sortDirection, HorseStudRegisterSortOrder sortObject, Object filterObject) {
        return new HorseStudRegisterPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

