/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.stud;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.stud.HorseStudRegistration;
import java.sql.Date;
import java.util.List;

public class HorseStudRegistrationDatabase
implements RepositoryDatasource<HorseStudRegistration, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_STUD_REGISTRY_ID = "STUD_REGISTRY_ID";
    private static final String COLUMN_REGISTRATION_DATE = "REGISTRATION_DATE";
    private static final String COLUMN_EXPIRY_DATE = "EXPIRY_DATE";
    private static final String COLUMN_LAST_RENEWAL_DATE = "LAST_RENEWAL_DATE";

    @Override
    public void create(HorseStudRegistration horseStudRegistration) {
        Query.insertInto("HORSE_STUD_REGISTRATION").columns(QueryColumn.column(COLUMN_HORSE_ID, horseStudRegistration.getHorseId()), QueryColumn.column(COLUMN_STUD_REGISTRY_ID, horseStudRegistration.getRegistryId()), QueryColumn.column(COLUMN_REGISTRATION_DATE, horseStudRegistration.getRegistrationDate()), QueryColumn.column(COLUMN_EXPIRY_DATE, horseStudRegistration.getExpiryDate()), QueryColumn.column(COLUMN_LAST_RENEWAL_DATE, horseStudRegistration.getLastRenewalDate())).executeGetGeneratedKey(horseStudRegistration::setId);
    }

    @Override
    public List<HorseStudRegistration> retrieveAll() {
        return Query.selectAllFrom("HORSE_STUD_REGISTRATION").getList(this::getFromResultRow);
    }

    private HorseStudRegistration getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int registryId = row.getInt(COLUMN_STUD_REGISTRY_ID);
        Date registrationDate = row.getDate(COLUMN_REGISTRATION_DATE);
        Date expiryDate = row.getDate(COLUMN_EXPIRY_DATE);
        Date renewalDate = row.getDate(COLUMN_LAST_RENEWAL_DATE);
        return new HorseStudRegistration(id, horseId, registryId, registrationDate, expiryDate, renewalDate);
    }

    @Override
    public void update(HorseStudRegistration horseStudRegistration) {
        Query.update("HORSE_STUD_REGISTRATION").set(QueryColumn.column(COLUMN_EXPIRY_DATE, horseStudRegistration.getExpiryDate()), QueryColumn.column(COLUMN_LAST_RENEWAL_DATE, horseStudRegistration.getLastRenewalDate())).where(QueryColumn.column(COLUMN_ID, horseStudRegistration.getId())).execute();
    }

    @Override
    public void deleteByKey(Integer id) {
        Query.deleteFrom("HORSE_STUD_REGISTRATION").where(QueryColumn.column(COLUMN_ID, id));
    }
}

