/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.stud;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.InvalidGenderException;
import com.equestricraft.core.horse.stud.HorseStudRegistration;
import com.equestricraft.core.horse.stud.HorseStudRegistrationRepository;
import com.equestricraft.core.horse.stud.HorseStudRegistrationSession;
import com.equestricraft.core.horse.stud.StudAlreadyRegisteredException;
import com.equestricraft.core.horse.stud.StudNotRegisteredException;
import com.equestricraft.core.horse.stud.StudRegisterEntry;
import com.equestricraft.core.horse.stud.StudRegistrationResponse;
import com.equestricraft.core.horse.stud.StudRegistrationStatus;
import com.equestricraft.core.horse.stud.StudRenewalResponse;
import com.equestricraft.core.horse.stud.StudRequirementCheckException;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.core.studregistry.StudRegistry;
import com.equestricraft.core.studregistry.StudRegistryRepository;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HorseStudRegistrationSessionImpl
implements HorseStudRegistrationSession {
    @Service
    private HorseStudRegistrationRepository horseStudRegistrationRepository;
    @Service
    private StudRegistryRepository studRegistryRepository;
    @Service
    private HorseRepository horseRepository;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public StudRegistrationResponse registerStud(EQHorse horse, int groupId) throws StudAlreadyRegisteredException, InvalidGenderException, EconomyException, StudRequirementCheckException {
        this.ensureStallion(horse);
        if (this.isRegistered(horse)) {
            throw new StudAlreadyRegisteredException(I18n.getLabel("horse.stud-registration.already-registered"));
        }
        StudRegistry groupToJoin = (StudRegistry)this.studRegistryRepository.findByKey(groupId);
        this.checkInitialRequirementScript(groupToJoin, horse);
        this.checkRequirementScript(groupToJoin, horse);
        double fee = groupToJoin.getInitialFee();
        SingleAccountEconomyResponse economyResponse = horse.getOwner().getEconomy().withdraw(fee, I18n.getLabel("horse.stud-registration.initial-fee-transaction"), "Stud Registration");
        Date date = new Date();
        Date expiryDate = this.calculateExpiryDate(date);
        HorseStudRegistration newRegistration = new HorseStudRegistration(0, horse.getId(), groupToJoin.getId(), date, date, expiryDate);
        this.horseStudRegistrationRepository.add(newRegistration);
        return new StudRegistrationResponse(groupToJoin.getId(), groupToJoin.getName(), economyResponse.balanceFormatted(), DateUtils.daysUntil(expiryDate));
    }

    private boolean isRegistered(EQHorse h) {
        return this.horseStudRegistrationRepository.findByHorseId(h.getId()).isPresent();
    }

    private void checkInitialRequirementScript(StudRegistry studRegistry, EQHorse horse) throws StudRequirementCheckException {
        this.checkScript(studRegistry.getInitialRequirementScript(), horse);
    }

    private void checkRequirementScript(StudRegistry studRegistry, EQHorse horse) throws StudRequirementCheckException {
        this.checkScript(studRegistry.getRequirementScript(), horse);
    }

    private void checkScript(String script, EQHorse horse) throws StudRequirementCheckException {
        if (script.isEmpty()) {
            return;
        }
        APIHorseDtoImpl horseDto = new APIHorseDtoImpl(horse);
        try {
            RuleScriptResponse response = ((GroovyRuleScriptExecutor)GroovyRuleScriptExecutor.start(script).withHorse(horseDto)).execute().result();
            if (Boolean.FALSE.equals(response.success())) {
                throw new StudRequirementCheckException(response.promptRequest().getMessage(), response.promptRequest().getTitle());
            }
        }
        catch (GroovyException ex) {
            throw new StudRequirementCheckException(ex.getMessage());
        }
    }

    @Override
    public StudRenewalResponse renewRegistration(EQHorse horse) throws StudNotRegisteredException, InvalidGenderException, EconomyException, StudRequirementCheckException {
        this.ensureStallion(horse);
        HorseStudRegistration horsesCurrentRegistration = this.horseStudRegistrationRepository.findByHorseId(horse.getId()).orElseThrow(() -> new StudNotRegisteredException(I18n.getLabel("horse.stud-registration.not-registered")));
        StudRegistry registry = (StudRegistry)this.studRegistryRepository.findByKey(horsesCurrentRegistration.getRegistryId());
        this.checkRequirementScript(registry, horse);
        double fee = registry.getRenewalFee();
        SingleAccountEconomyResponse economyResponse = horse.getOwner().getEconomy().withdraw(fee, I18n.getLabel("horse.stud-registration.renewal-fee-transaction"), "Stud Registration");
        Date date = new Date();
        horsesCurrentRegistration.setLastRenewalDate(date);
        Date expiry = this.calculateExpiryDate(date);
        horsesCurrentRegistration.setExpiryDate(expiry);
        horsesCurrentRegistration.save();
        return new StudRenewalResponse(economyResponse.balanceFormatted(), DateUtils.daysUntil(expiry));
    }

    private void ensureStallion(EQHorse horse) throws InvalidGenderException {
        if (horse.getHorseGender() != HorseGender.STALLION) {
            throw new InvalidGenderException(I18n.getLabel("horse.stud-registration.not-a-stallion"));
        }
    }

    private Date calculateExpiryDate(Date date) {
        return DateUtils.futureDaysOffset(date, HorseSettings.getStudRegistrationDurationDays());
    }

    @Override
    public void removeRegistration(EQHorse horse) throws StudNotRegisteredException {
        HorseStudRegistration existingRegistration = this.horseStudRegistrationRepository.findByHorseId(horse.getId()).orElseThrow(() -> new StudNotRegisteredException(I18n.getLabel("horse.stud-registration.not-registered")));
        this.horseStudRegistrationRepository.remove(existingRegistration);
    }

    @Override
    public StudRegistrationStatus getRegistrationStatus(EQHorse horse) {
        Optional<HorseStudRegistration> registration = this.horseStudRegistrationRepository.findByHorseId(horse.getId());
        if (registration.isPresent()) {
            return this.getRegistrationStatus(registration.get());
        }
        return StudRegistrationStatus.NONE;
    }

    @Override
    public StudRegistrationStatus getRegistrationStatus(HorseStudRegistration registration) {
        if (DateUtils.isInPast(registration.getExpiryDate())) {
            return StudRegistrationStatus.EXPIRED;
        }
        return StudRegistrationStatus.ACTIVE;
    }

    @Override
    public List<StudRegisterEntry> retrieveStudRegister() {
        List<EQHorse> horses = this.horseRepository.findAllLivingHorses();
        return horses.stream().map(this::buildEntry).filter(Objects::nonNull).toList();
    }

    private StudRegisterEntry buildEntry(EQHorse h) {
        return this.horseStudRegistrationRepository.findByHorseId(h.getId()).map(r -> this.buildEntry((HorseStudRegistration)r, h)).orElse(null);
    }

    private StudRegisterEntry buildEntry(HorseStudRegistration r, EQHorse h) {
        StudRegistrationStatus status = this.getRegistrationStatus(r);
        StudRegistry registry = (StudRegistry)this.studRegistryRepository.findByKey(r.getRegistryId());
        return new StudRegisterEntry(r.getId(), registry.getId(), registry.getName(), h.getShowName(), this.playerTransformer.toSimple(h.getOwner().getCorePlayer()), r.getRegistrationDate(), r.getLastRenewalDate(), r.getExpiryDate(), status);
    }
}

