/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.symptom;

import com.equestricraft.api.common.APIHorseSymptomDto;
import com.equestricraft.api.common.APIHorseSymptomsDto;
import com.equestricraft.api.common.APIIllnessSymptomDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.horse.symptom.APIHorseSymptomDtoImpl;
import com.equestricraft.core.horse.symptom.HorseSymptom;
import com.equestricraft.core.horse.symptom.HorseSymptomAccessor;
import com.equestricraft.core.illness.symptom.APIIllnessSymptomDtoImpl;
import com.equestricraft.core.illness.symptom.IllnessSymptom;
import com.equestricraft.core.illness.symptom.IllnessSymptomRepository;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import java.util.Set;

public class APIHorseSymptomsDtoImpl
extends MapAdapter<APIIllnessSymptomDto, APIHorseSymptomDto>
implements APIHorseSymptomsDto {
    private final HorseSymptomAccessor horseSymptomAccessor;
    private List<HorseSymptom> symptoms = null;
    @Service
    private static IllnessSymptomRepository illnessSymptomRepository;

    public APIHorseSymptomsDtoImpl(HorseSymptomAccessor horseSymptomAccessor) {
        this.horseSymptomAccessor = horseSymptomAccessor;
    }

    @Override
    public int size() {
        return this.ensureLoaded().size();
    }

    @Override
    public APIHorseSymptomDto get(Object key) {
        IllnessSymptom symptom = this.getFromKey(key);
        OptionalDouble percentage = this.horseSymptomAccessor.getSymptomPercentage(symptom);
        if (percentage.isPresent()) {
            return new APIHorseSymptomDtoImpl(new HorseSymptom(symptom, percentage.getAsDouble()));
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        IllnessSymptom symptom = this.getFromKey(key);
        return this.horseSymptomAccessor.getSymptomPercentage(symptom).isPresent();
    }

    private IllnessSymptom getFromKey(Object key) {
        if (key instanceof APIIllnessSymptomDtoImpl) {
            APIIllnessSymptomDtoImpl apiIllnessSymptomDto = (APIIllnessSymptomDtoImpl)key;
            return apiIllnessSymptomDto.getIllnessSymptom();
        }
        if (key instanceof String) {
            String identifier = (String)key;
            return illnessSymptomRepository.findByIdentifier(identifier).orElseThrow();
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return (IllnessSymptom)illnessSymptomRepository.findByKey(id);
        }
        throw new IllegalArgumentException("Invalid key provided");
    }

    private List<HorseSymptom> ensureLoaded() {
        if (this.symptoms == null) {
            this.symptoms = this.horseSymptomAccessor.getActive();
        }
        return this.symptoms;
    }

    @Override
    public Set<Map.Entry<APIIllnessSymptomDto, APIHorseSymptomDto>> entrySet() {
        this.ensureLoaded();
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<APIIllnessSymptomDto, APIHorseSymptomDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<APIIllnessSymptomDto, APIHorseSymptomDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return APIHorseSymptomsDtoImpl.this.size();
        }

        final class EntrySetIterator
        implements Iterator<Map.Entry<APIIllnessSymptomDto, APIHorseSymptomDto>> {
            private int currentIndex = 0;

            EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return EntrySet.this.size() > this.currentIndex;
            }

            @Override
            public Map.Entry<APIIllnessSymptomDto, APIHorseSymptomDto> next() {
                if (this.hasNext()) {
                    HorseSymptom symptom = APIHorseSymptomsDtoImpl.this.symptoms.get(this.currentIndex++);
                    APIHorseSymptomDtoImpl dto = new APIHorseSymptomDtoImpl(symptom);
                    return Map.entry(dto.getSymptom(), dto);
                }
                throw new NoSuchElementException();
            }
        }
    }
}

