/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.symptom;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.horse.illness.IllnessSymptomInformation;
import com.equestricraft.core.horse.symptom.HorseSymptom;
import com.equestricraft.core.horse.symptom.HorseSymptomCollector;
import com.equestricraft.core.horse.symptom.HorseSymptomProvider;
import com.equestricraft.core.illness.IllnessSession;
import com.equestricraft.core.illness.symptom.IllnessSymptom;
import com.equestricraft.core.illness.symptom.IllnessSymptomMapping;
import com.equestricraft.core.player.ECPlayer;
import java.util.List;
import java.util.OptionalDouble;

public class HorseSymptomAccessor
extends AbstractHorseAccessor {
    @Service
    private static ServiceInstance<HorseSymptomProvider> horseSymptomProviders;
    @Service
    private static IllnessSession illnessSession;

    public HorseSymptomAccessor(EQHorse horse) {
        super(horse);
    }

    public List<HorseSymptom> getActive() {
        return horseSymptomProviders.stream().flatMap(p -> p.getSymptoms(this.horse)).collect(new HorseSymptomCollector());
    }

    public OptionalDouble getSymptomPercentage(IllnessSymptom illnessSymptom) {
        return horseSymptomProviders.stream().flatMapToDouble(p -> p.getPercentagesForSymptom(this.horse, illnessSymptom)).max();
    }

    public List<IllnessSymptomInformation> retrieveSymptomInformationForPlayer(ECPlayer player) {
        List<IllnessHorse> illnesses = this.horse.getIllness().getUncured();
        return illnesses.stream().filter(ih -> this.canPlayerSeeIllnessSymptoms(player, (IllnessHorse)ih)).flatMap(ih -> ih.getActiveEffects().stream()).flatMap(e -> e.getSymptoms().stream()).map(IllnessSymptomMapping::getSymptom).distinct().map(s -> new IllnessSymptomInformation(s.getName(), s.getDescription())).toList();
    }

    public boolean hasVisibleSymptoms(ECPlayer player) {
        List<IllnessHorse> uncured = this.horse.getIllness().getUncured();
        return uncured.stream().anyMatch(ih -> this.canPlayerSeeIllnessSymptoms(player, (IllnessHorse)ih));
    }

    private boolean canPlayerSeeIllnessSymptoms(ECPlayer viewingPlayer, IllnessHorse illnessHorse) {
        if (!illnessHorse.getIllness().isDiagnosisNeeded()) {
            return true;
        }
        return illnessHorse.isAware() || illnessSession.canSeeAdvancedIllnessInformation(viewingPlayer, illnessHorse.getIllness());
    }
}

