/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.symptom.symptomprovider;

import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.symptom.HorseSymptom;
import com.equestricraft.core.illness.symptom.IllnessSymptom;
import java.util.List;
import java.util.function.ToDoubleFunction;

public abstract class AbstractIllnessSymptomStatProvider {
    float getHorsesPercentageFromIllnesses(EQHorse horse, ToDoubleFunction<IllnessSymptom> percentageFunction) {
        List<HorseSymptom> symptoms = horse.getSymptoms().getActive();
        return symptoms.stream().map(symptom -> {
            float valueFromSymptom = (float)(percentageFunction.applyAsDouble(symptom.getSymptom()) / 100.0);
            float horsesCurrentValue = (float)(symptom.getPercentage() / 100.0);
            return Float.valueOf(valueFromSymptom * horsesCurrentValue);
        }).max(Float::compare).orElse(Float.valueOf(1.0f)).floatValue();
    }
}

