/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.symptom.symptomprovider;

import com.equestricraft.core.blood.BloodUnit;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.blood.HorseBloodUnitStatProvider;
import com.equestricraft.core.horse.symptom.symptomprovider.AbstractIllnessSymptomStatProvider;
import com.equestricraft.core.illness.symptom.IllnessSymptomBlood;
import java.util.function.ToIntFunction;

public class IllnessBloodUnitProvider
extends AbstractIllnessSymptomStatProvider
implements HorseBloodUnitStatProvider {
    @Override
    public float getFactorForBloodUnit(EQHorse horse, BloodUnit bloodUnit) {
        ToIntFunction<IllnessSymptomBlood> valueFunction = this.getBloodPercentageFunction(bloodUnit);
        return this.getHorsesPercentageFromIllnesses(horse, s -> valueFunction.applyAsInt(s.getIllnessSymptomBlood()));
    }

    private ToIntFunction<IllnessSymptomBlood> getBloodPercentageFunction(BloodUnit bloodUnit) {
        return switch (bloodUnit) {
            default -> throw new IncompatibleClassChangeError();
            case BloodUnit.RED_BLOOD_CELL -> IllnessSymptomBlood::getRedBloodCellPercentage;
            case BloodUnit.WHITE_BLOOD_CELL -> IllnessSymptomBlood::getWhiteBloodCellPercentage;
            case BloodUnit.PLATELETS -> IllnessSymptomBlood::getPlateletsPercentage;
            case BloodUnit.ELECTROLYTES -> IllnessSymptomBlood::getElectrolytesPercentage;
            case BloodUnit.ENZYMES -> IllnessSymptomBlood::getEnzymesPercentage;
            case BloodUnit.PROTEIN -> IllnessSymptomBlood::getProteinPercentage;
            case BloodUnit.OXYGEN -> IllnessSymptomBlood::getOxygenPercentage;
            case BloodUnit.CARBON_DIOXIDE -> IllnessSymptomBlood::getCarbonDioxidePercentage;
            case BloodUnit.NITROGEN -> IllnessSymptomBlood::getNitrogenPercentage;
        };
    }
}

