/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.tack;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.tack.TackType;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.player.tack.HorseTackInfo;
import com.equestricraft.core.player.tack.bonnet.HorseBonnetInventoryItem;
import com.equestricraft.core.player.tack.bonnet.HorseBonnetInventorySession;
import com.equestricraft.core.player.tack.boots.HorseBootsInventoryItem;
import com.equestricraft.core.player.tack.boots.HorseBootsInventorySession;
import com.equestricraft.core.player.tack.bridle.HorseBridleInventoryItem;
import com.equestricraft.core.player.tack.bridle.HorseBridleInventorySession;
import com.equestricraft.core.player.tack.cinch.HorseCinchInventoryItem;
import com.equestricraft.core.player.tack.cinch.HorseCinchInventorySession;
import com.equestricraft.core.player.tack.girth.HorseGirthInventoryItem;
import com.equestricraft.core.player.tack.girth.HorseGirthInventorySession;
import com.equestricraft.core.player.tack.halter.HorseHalterInventoryItem;
import com.equestricraft.core.player.tack.halter.HorseHalterInventorySession;
import com.equestricraft.core.player.tack.pad.HorsePadInventoryItem;
import com.equestricraft.core.player.tack.pad.HorsePadInventorySession;
import com.equestricraft.core.player.tack.rein.HorseReinInventoryItem;
import com.equestricraft.core.player.tack.rein.HorseReinInventorySession;
import com.equestricraft.core.player.tack.saddle.HorseSaddleInventoryItem;
import com.equestricraft.core.player.tack.saddle.HorseSaddleInventorySession;
import com.equestricraft.core.player.tack.wraps.HorseWrapsInventoryItem;
import com.equestricraft.core.player.tack.wraps.HorseWrapsInventorySession;
import com.equestricraft.core.tack.bonnet.HorseBonnet;
import com.equestricraft.core.tack.boots.HorseBoots;
import com.equestricraft.core.tack.bridle.HorseBridle;
import com.equestricraft.core.tack.cinch.HorseCinch;
import com.equestricraft.core.tack.girth.HorseGirth;
import com.equestricraft.core.tack.halter.HorseHalter;
import com.equestricraft.core.tack.pad.HorsePad;
import com.equestricraft.core.tack.rein.HorseRein;
import com.equestricraft.core.tack.saddle.HorseSaddle;
import com.equestricraft.core.tack.wraps.HorseWraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class HorseTackAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseBonnetInventorySession horseBonnetInventorySession;
    @Service
    private static HorseBootsInventorySession horseBootsInventorySession;
    @Service
    private static HorseBridleInventorySession horseBridleInventorySession;
    @Service
    private static HorseCinchInventorySession horseCinchInventorySession;
    @Service
    private static HorseGirthInventorySession horseGirthInventorySession;
    @Service
    private static HorseHalterInventorySession horseHalterInventorySession;
    @Service
    private static HorsePadInventorySession horsePadInventorySession;
    @Service
    private static HorseReinInventorySession horseReinInventorySession;
    @Service
    private static HorseSaddleInventorySession horseSaddleInventorySession;
    @Service
    private static HorseWrapsInventorySession horseWrapsInventorySession;

    public HorseTackAccessor(EQHorse horse) {
        super(horse);
    }

    public Optional<HorseTackInfo<HorseBonnet, HorseBonnetInventoryItem>> getBonnet() {
        if (this.horse.getBonnetItemId() != null) {
            HorseTackInfo<HorseBonnet, HorseBonnetInventoryItem> bonnet = horseBonnetInventorySession.getBonnetForItem(this.horse.getBonnetItemId());
            return Optional.of(bonnet);
        }
        return Optional.empty();
    }

    public Optional<HorseTackInfo<HorseBoots, HorseBootsInventoryItem>> getBoots() {
        if (this.horse.getBootsItemId() != null) {
            HorseTackInfo<HorseBoots, HorseBootsInventoryItem> boots = horseBootsInventorySession.getBootsForItem(this.horse.getBootsItemId());
            return Optional.of(boots);
        }
        return Optional.empty();
    }

    public Optional<HorseTackInfo<HorseBridle, HorseBridleInventoryItem>> getBridle() {
        if (this.horse.getBridleItemId() != null) {
            HorseTackInfo<HorseBridle, HorseBridleInventoryItem> bridle = horseBridleInventorySession.getBridleForItem(this.horse.getBridleItemId());
            return Optional.of(bridle);
        }
        return Optional.empty();
    }

    public Optional<HorseTackInfo<HorseCinch, HorseCinchInventoryItem>> getCinch() {
        if (this.horse.getCinchItemId() != null) {
            HorseTackInfo<HorseCinch, HorseCinchInventoryItem> cinch = horseCinchInventorySession.getCinchForItem(this.horse.getCinchItemId());
            return Optional.of(cinch);
        }
        return Optional.empty();
    }

    public Optional<HorseTackInfo<HorseGirth, HorseGirthInventoryItem>> getGirth() {
        if (this.horse.getGirthItemId() != null) {
            HorseTackInfo<HorseGirth, HorseGirthInventoryItem> girth = horseGirthInventorySession.getGirthForItem(this.horse.getGirthItemId());
            return Optional.of(girth);
        }
        return Optional.empty();
    }

    public Optional<HorseTackInfo<HorseHalter, HorseHalterInventoryItem>> getHalter() {
        if (this.horse.getHalterItemId() != null) {
            HorseTackInfo<HorseHalter, HorseHalterInventoryItem> halter = horseHalterInventorySession.getHalterForItem(this.horse.getHalterItemId());
            return Optional.of(halter);
        }
        return Optional.empty();
    }

    public Optional<HorseTackInfo<HorsePad, HorsePadInventoryItem>> getPad() {
        if (this.horse.getPadItemId() != null) {
            HorseTackInfo<HorsePad, HorsePadInventoryItem> pad = horsePadInventorySession.getPadForItem(this.horse.getPadItemId());
            return Optional.of(pad);
        }
        return Optional.empty();
    }

    public Optional<HorseTackInfo<HorseRein, HorseReinInventoryItem>> getRein() {
        if (this.horse.getReinItemId() != null) {
            HorseTackInfo<HorseRein, HorseReinInventoryItem> rein = horseReinInventorySession.getReinForItem(this.horse.getReinItemId());
            return Optional.of(rein);
        }
        return Optional.empty();
    }

    public Optional<HorseTackInfo<HorseSaddle, HorseSaddleInventoryItem>> getSaddle() {
        if (this.horse.getSaddleItemId() != null) {
            HorseTackInfo<HorseSaddle, HorseSaddleInventoryItem> saddle = horseSaddleInventorySession.getSaddleForItem(this.horse.getSaddleItemId());
            return Optional.of(saddle);
        }
        return Optional.empty();
    }

    public Optional<HorseTackInfo<HorseWraps, HorseWrapsInventoryItem>> getWraps() {
        if (this.horse.getWrapsItemId() != null) {
            HorseTackInfo<HorseWraps, HorseWrapsInventoryItem> wraps = horseWrapsInventorySession.getWrapsForItem(this.horse.getWrapsItemId());
            return Optional.of(wraps);
        }
        return Optional.empty();
    }

    public Optional<HorseTackInfo<?, ?>> getTackForType(TackType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TackType.BONNET -> this.getBonnet().map(tack -> tack);
            case TackType.BOOTS -> this.getBoots().map(tack -> tack);
            case TackType.BRIDLE -> this.getBridle().map(tack -> tack);
            case TackType.CINCH -> this.getCinch().map(tack -> tack);
            case TackType.GIRTH -> this.getGirth().map(tack -> tack);
            case TackType.HALTER -> this.getHalter().map(tack -> tack);
            case TackType.PAD -> this.getPad().map(tack -> tack);
            case TackType.REIN -> this.getRein().map(tack -> tack);
            case TackType.SADDLE -> this.getSaddle().map(tack -> tack);
            case TackType.WRAPS -> this.getWraps().map(tack -> tack);
        };
    }

    public List<HorseTackInfo<?, ?>> getAllTack() {
        ArrayList tack = new ArrayList();
        this.getBonnet().ifPresent(tack::add);
        this.getBoots().ifPresent(tack::add);
        this.getBridle().ifPresent(tack::add);
        this.getCinch().ifPresent(tack::add);
        this.getGirth().ifPresent(tack::add);
        this.getHalter().ifPresent(tack::add);
        this.getPad().ifPresent(tack::add);
        this.getRein().ifPresent(tack::add);
        this.getSaddle().ifPresent(tack::add);
        this.getWraps().ifPresent(tack::add);
        return tack;
    }
}

