/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.tack;

import com.equestricraft.common.tack.TackType;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.tack.HorseTackAccessor;
import com.equestricraft.core.horse.tack.HorseTackSession;
import com.equestricraft.core.player.tack.HorseTackInfo;
import com.equestricraft.core.player.tack.TackInventoryItem;
import com.equestricraft.core.tack.Tack;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.ToDoubleFunction;

public class HorseTackSessionImpl
implements HorseTackSession {
    @Override
    public float getSpeedOffsetFactor(EQHorse horse) {
        return (float)this.calculateValueFromTack(horse, Tack::getSpeedPercentageOffset) / 100.0f;
    }

    @Override
    public float getMaximumStaminaOffset(EQHorse horse) {
        return (float)this.calculateValueFromTack(horse, Tack::getMaximumStaminaOffsetPercentage) / 100.0f;
    }

    @Override
    public long getStaminaOffsetPerTickOffsetFromTack(EQHorse horse) {
        return (long)(100.0 - this.calculateValueFromTack(horse, Tack::getStaminaOffsetPerTickOffset));
    }

    private double calculateValueFromTack(EQHorse horse, ToDoubleFunction<Tack> function) {
        HorseTackAccessor horseTack = horse.getTacks();
        return Arrays.stream(TackType.values()).map(horseTack::getTackForType).filter(Optional::isPresent).map(Optional::get).mapToDouble(t -> {
            double value = function.applyAsDouble((Tack)t.tack());
            return PercentageUtils.of(value, t.getConditionPercentage());
        }).average().orElse(100.0);
    }

    @Override
    public void increaseWearForTack(EQHorse horse, Duration ridingDuration) {
        long millisToAdd = ridingDuration.toMillis();
        List<HorseTackInfo<?, ?>> tackList = horse.getTacks().getAllTack();
        for (HorseTackInfo<?, ?> tack : tackList) {
            long newMillis = ((TackInventoryItem)tack.inventoryItem()).getTotalWearDuration() + millisToAdd;
            ((TackInventoryItem)tack.inventoryItem()).setTotalWearDuration(newMillis);
            tack.inventoryItem().save();
        }
    }
}

