/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.tag;

import com.equestricraft.api.common.APIHorseTagValueDto;
import com.equestricraft.api.common.APIHorseTagsDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.horse.tag.APIHorseTagValueDtoImpl;
import com.equestricraft.core.horse.tag.HorseTagsAccessor;
import com.equestricraft.core.tag.Tag;
import com.equestricraft.core.tag.TagRepository;
import groovy.lang.Range;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class APIHorseTagsDtoImpl
extends MapAdapter<String, APIHorseTagValueDto>
implements APIHorseTagsDto {
    private final HorseTagsAccessor horseTagsAccessor;
    private final List<Tag> tags;
    @Service
    private static TagRepository tagRepository;

    public APIHorseTagsDtoImpl(HorseTagsAccessor horseTagsAccessor) {
        this.horseTagsAccessor = horseTagsAccessor;
        this.tags = tagRepository.findAll();
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public APIHorseTagValueDto get(Object key) {
        return new APIHorseTagValueDtoImpl(key.toString(), this.horseTagsAccessor);
    }

    @Override
    public APIHorseTagValueDto put(String key, APIHorseTagValueDto value) {
        this.horseTagsAccessor.setValueForTag(key, value.getValue());
        return new APIHorseTagValueDtoImpl(key, this.horseTagsAccessor);
    }

    @Override
    public boolean greaterThan(Map<String, Double> values2) {
        return values2.entrySet().stream().allMatch(e -> this.get(e.getKey()).getValue() > (Double)e.getValue());
    }

    @Override
    public boolean lessThan(Map<String, Double> values2) {
        return values2.entrySet().stream().allMatch(e -> this.get(e.getKey()).getValue() < (Double)e.getValue());
    }

    @Override
    public boolean matches(Map<String, Range<Double>> values2) {
        return values2.entrySet().stream().allMatch(e -> ((Range)e.getValue()).containsWithinBounds(e.getValue()));
    }

    @Override
    public Set<Map.Entry<String, APIHorseTagValueDto>> entrySet() {
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, APIHorseTagValueDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, APIHorseTagValueDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return APIHorseTagsDtoImpl.this.tags.size();
        }

        final class EntrySetIterator
        implements Iterator<Map.Entry<String, APIHorseTagValueDto>> {
            private final Iterator<Tag> iterator;

            EntrySetIterator() {
                this.iterator = APIHorseTagsDtoImpl.this.tags.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<String, APIHorseTagValueDto> next() {
                Tag next = this.iterator.next();
                APIHorseTagValueDtoImpl dto = new APIHorseTagValueDtoImpl(next.getName(), APIHorseTagsDtoImpl.this.horseTagsAccessor);
                return Map.entry(next.getName(), dto);
            }
        }
    }
}

