/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.tag;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.tag.HorseTagValueKey;
import com.equestricraft.core.horse.tag.HorseTagValueRepository;
import java.util.Objects;
import java.util.UUID;

public class HorseTagValue
implements RepositoryEntity<HorseTagValueKey> {
    private final HorseTagValueKey key;
    private double value;

    public HorseTagValue(int horseId, UUID tagId, double value) {
        this.key = new HorseTagValueKey(horseId, tagId);
        this.value = value;
    }

    @Override
    public HorseTagValueKey getKey() {
        return this.key;
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    public UUID getTagId() {
        return this.getKey().tagId();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void save() {
        Services.getService(HorseTagValueRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseTagValue that = (HorseTagValue)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    public String toString() {
        return "" + this.getValue();
    }
}

