/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.tag;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.tag.HorseTagValue;
import com.equestricraft.core.horse.tag.HorseTagValueKey;
import java.util.List;
import java.util.UUID;

public class HorseTagValueDatabase
implements RepositoryDatasource<HorseTagValue, HorseTagValueKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_TAG_ID = "TAG_ID";
    private static final String COLUMN_VALUE = "VALUE";

    @Override
    public void create(HorseTagValue horseTagValue) {
        Query.insertInto("HORSE_TAG_VALUE").columns(QueryColumn.column(COLUMN_HORSE_ID, horseTagValue.getHorseId()), QueryColumn.column(COLUMN_TAG_ID, horseTagValue.getTagId()), QueryColumn.column(COLUMN_VALUE, horseTagValue.getValue())).execute();
    }

    @Override
    public List<HorseTagValue> retrieveAll() {
        return Query.selectAllFrom("HORSE_TAG_VALUE").getList(this::getFromResultRow);
    }

    @Override
    public void update(HorseTagValue horseTagValue) {
        Query.update("HORSE_TAG_VALUE").set(QueryColumn.column(COLUMN_VALUE, horseTagValue.getValue())).where(QueryColumn.column(COLUMN_HORSE_ID, horseTagValue.getHorseId()), QueryColumn.column(COLUMN_TAG_ID, horseTagValue.getTagId())).execute();
    }

    private HorseTagValue getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        UUID tagId = row.getUuid(COLUMN_TAG_ID);
        double value = row.getDouble(COLUMN_VALUE);
        return new HorseTagValue(horseId, tagId, value);
    }
}

