/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.tag;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.tag.HorseTagValue;
import com.equestricraft.core.horse.tag.HorseTagValueDatabase;
import com.equestricraft.core.horse.tag.HorseTagValueKey;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class HorseTagValueRepository
extends Repository<HorseTagValue, HorseTagValueKey> {
    @Service
    private HorseTagValueDatabase horseTagValueDatabase;

    @Override
    protected RepositoryDatasource<HorseTagValue, HorseTagValueKey> getDatasource() {
        return this.horseTagValueDatabase;
    }

    @Override
    protected Function<HorseTagValue, Object> getIndexFunction() {
        return HorseTagValue::getHorseId;
    }

    public List<HorseTagValue> findAllByHorse(int horseId) {
        return this.findListByIndexKey(horseId);
    }

    public Optional<HorseTagValue> findByHorseAndTag(int horseId, UUID tagId) {
        return this.findAllByHorse(horseId).stream().filter(t -> t.getTagId().equals(tagId)).findFirst();
    }
}

