/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.tag;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.tag.HorseTagValue;
import com.equestricraft.core.horse.tag.HorseTagValueRepository;
import com.equestricraft.core.tag.Tag;
import com.equestricraft.core.tag.TagRepository;
import java.util.Optional;
import java.util.UUID;

public class HorseTagsAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseTagValueRepository horseTagValueRepository;
    @Service
    private static TagRepository tagRepository;

    public HorseTagsAccessor(EQHorse horse) {
        super(horse);
    }

    public double getValueForTag(String tagName) {
        Tag tag = tagRepository.getByName(tagName);
        return this.getValueForTag(tag.getId());
    }

    public double getValueForTag(UUID tagId) {
        Optional<HorseTagValue> tag = horseTagValueRepository.findByHorseAndTag(this.horse.getId(), tagId);
        return tag.map(HorseTagValue::getValue).orElse(0.0);
    }

    public double setValueForTag(String tagName, double value) {
        Tag tag = tagRepository.getByName(tagName);
        return this.setValueForTag(tag.getId(), value);
    }

    public double setValueForTag(UUID tagId, double value) {
        Optional<HorseTagValue> tag = horseTagValueRepository.findByHorseAndTag(this.horse.getId(), tagId);
        if (tag.isPresent()) {
            HorseTagValue t = tag.get();
            double existingValue = t.getValue();
            t.setValue(value);
            horseTagValueRepository.update(t);
            return existingValue;
        }
        HorseTagValue newValue = new HorseTagValue(this.horse.getId(), tagId, value);
        horseTagValueRepository.add(newValue);
        return 0.0;
    }

    public void increaseValueForTag(String tagName, double amount) {
        Tag tag = tagRepository.getByName(tagName);
        this.increaseValueForTag(tag.getId(), amount);
    }

    public void increaseValueForTag(UUID tagId, double amount) {
        this.offsetValueForTag(tagId, amount);
    }

    public void increaseValueForTag(UUID tagId) {
        this.increaseValueForTag(tagId, 1.0);
    }

    public void decreaseValueForTag(String tagName, double amount) {
        Tag tag = tagRepository.getByName(tagName);
        this.decreaseValueForTag(tag.getId(), amount);
    }

    public void decreaseValueForTag(UUID tagId, double amount) {
        this.offsetValueForTag(tagId, -amount);
    }

    public void decreaseValueForTag(UUID tagId) {
        this.decreaseValueForTag(tagId, 1.0);
    }

    public void offsetValueForTag(String tagName, double amount) {
        Tag tag = tagRepository.getByName(tagName);
        this.offsetValueForTag(tag.getId(), amount);
    }

    public void offsetValueForTag(UUID tagId, double amount) {
        Optional<HorseTagValue> tag = horseTagValueRepository.findByHorseAndTag(this.horse.getId(), tagId);
        if (tag.isPresent()) {
            HorseTagValue t = tag.get();
            t.setValue(t.getValue() + amount);
            horseTagValueRepository.update(t);
        } else {
            HorseTagValue newTag = new HorseTagValue(this.horse.getId(), tagId, amount);
            horseTagValueRepository.add(newTag);
        }
    }
}

