/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.texture;

import java.util.List;

public record HorseTextureDetails(String colorName, List<String> markings, String grayName, String textureOverride) {
    public HorseTextureDetails {
        if (colorName != null && grayName != null && textureOverride != null) {
            throw new IllegalArgumentException("Only a name or override should be provided, not both");
        }
        if (colorName == null && grayName == null && textureOverride == null) {
            throw new IllegalArgumentException("Must supply either a name or an override");
        }
    }

    public boolean hasTextureOverride() {
        return this.textureOverride != null;
    }

    public static HorseTextureDetails withName(String colorName, List<String> markings, String grayName) {
        return new HorseTextureDetails(colorName, markings, grayName, null);
    }

    public static HorseTextureDetails withOverride(String override) {
        return new HorseTextureDetails(null, null, null, override);
    }
}

