/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.texture;

import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.horse.texture.HorseTextureDetails;
import com.equestricraft.core.horse.texture.HorseTextureSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HorseTextureSessionImpl
implements HorseTextureSession {
    private static final Map<Float, String> grayScaleMap = HorseTextureSessionImpl.createGrayScaleMap();
    private static final Map<Float, String> roseGrayScaleMap = HorseTextureSessionImpl.createRoseGrayScaleMap();

    @Override
    public HorseTextureDetails calculateTextureNameForHorse(EQHorse horse) {
        HorseCoatDetails details = horse.getCoat().getDetails();
        String color = this.determineColor(details);
        List<String> markings = this.determineMarkings(details);
        String gray = this.determineGray(details);
        return HorseTextureDetails.withName(color, markings, gray);
    }

    private String determineColor(HorseCoatDetails details) {
        return details.getColor().getTextureFile().toLowerCase();
    }

    private List<String> determineMarkings(HorseCoatDetails details) {
        return details.getMarkings().stream().map(Enum::name).map(String::toLowerCase).toList();
    }

    private String determineGray(HorseCoatDetails details) {
        if (details.getGrayScale() == 0.0f) {
            return StringUtils.emptyString();
        }
        Map<Float, String> map = this.isChestnutColor(details) ? roseGrayScaleMap : grayScaleMap;
        for (Map.Entry<Float, String> entry : map.entrySet()) {
            if (!(details.getGrayScale() <= entry.getKey().floatValue())) continue;
            return entry.getValue().toLowerCase();
        }
        return StringUtils.emptyString();
    }

    private boolean isChestnutColor(HorseCoatDetails details) {
        return details.getColor() == HorseCoatColor.CHESTNUT || details.getColor() == HorseCoatColor.DARK_CHESTNUT || details.getColor() == HorseCoatColor.FLAXEN_CHESTNUT || details.getColor() == HorseCoatColor.LIGHT_CHESTNUT || details.getColor() == HorseCoatColor.FLAXEN_LIVER_CHESTNUT;
    }

    private static Map<Float, String> createGrayScaleMap() {
        HashMap<Float, String> map = new HashMap<Float, String>(6);
        map.put(Float.valueOf(0.16666667f), "gray_1");
        map.put(Float.valueOf(0.33333334f), "gray_2");
        map.put(Float.valueOf(0.5f), "gray_3");
        map.put(Float.valueOf(0.6666667f), "gray_4");
        map.put(Float.valueOf(0.8333333f), "gray_5");
        map.put(Float.valueOf(1.0f), "gray_6");
        return map;
    }

    private static Map<Float, String> createRoseGrayScaleMap() {
        HashMap<Float, String> map = new HashMap<Float, String>(6);
        map.put(Float.valueOf(0.5f), "gray_rose_1");
        map.put(Float.valueOf(1.0f), "gray_rose_2");
        return map;
    }
}

