/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.trust;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.trust.HorsePlayerTrustKey;
import com.equestricraft.core.horse.trust.HorsePlayerTrustRepository;
import java.util.Objects;

public class HorsePlayerTrust
implements RepositoryEntity<HorsePlayerTrustKey> {
    private final HorsePlayerTrustKey key;
    private int trustPoints;

    public HorsePlayerTrust(int horseId, int playerId, int trustPoints) {
        this.key = new HorsePlayerTrustKey(horseId, playerId);
        this.trustPoints = trustPoints;
    }

    @Override
    public HorsePlayerTrustKey getKey() {
        return this.key;
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    public int getPlayerId() {
        return this.getKey().playerId();
    }

    public int getTrustPoints() {
        return this.trustPoints;
    }

    public void setTrustPoints(int trustPoints) {
        this.trustPoints = trustPoints;
    }

    @Override
    public void save() {
        Services.getService(HorsePlayerTrustRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorsePlayerTrust that = (HorsePlayerTrust)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

