/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.trust;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.trust.HorsePlayerTrust;
import com.equestricraft.core.horse.trust.HorsePlayerTrustKey;
import java.util.List;

public class HorsePlayerTrustDatabase
implements RepositoryDatasource<HorsePlayerTrust, HorsePlayerTrustKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_TRUST_POINTS = "TRUST_POINTS";

    @Override
    public void create(HorsePlayerTrust horsePlayerTrust) {
        Query.insertInto("HORSE_PLAYER_TRUST").columns(QueryColumn.column(COLUMN_HORSE_ID, horsePlayerTrust.getHorseId()), QueryColumn.column(COLUMN_PLAYER_ID, horsePlayerTrust.getPlayerId()), QueryColumn.column(COLUMN_TRUST_POINTS, horsePlayerTrust.getTrustPoints())).execute();
    }

    @Override
    public List<HorsePlayerTrust> retrieveAll() {
        return Query.selectAllFrom("HORSE_PLAYER_TRUST").getList(this::getFromResultRow);
    }

    private HorsePlayerTrust getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        int trustPoints = row.getInt(COLUMN_TRUST_POINTS);
        return new HorsePlayerTrust(horseId, playerId, trustPoints);
    }

    @Override
    public void update(HorsePlayerTrust horsePlayerTrust) {
        Query.update("HORSE_PLAYER_TRUST").set(QueryColumn.column(COLUMN_TRUST_POINTS, horsePlayerTrust.getTrustPoints())).where(QueryColumn.column(COLUMN_HORSE_ID, horsePlayerTrust.getHorseId()), QueryColumn.column(COLUMN_PLAYER_ID, horsePlayerTrust.getPlayerId())).execute();
    }

    @Override
    public void deleteByKey(HorsePlayerTrustKey horsePlayerTrustKey) {
        Query.deleteFrom("HORSE_PLAYER_TRUST").where(QueryColumn.column(COLUMN_HORSE_ID, horsePlayerTrustKey.horseId()), QueryColumn.column(COLUMN_PLAYER_ID, horsePlayerTrustKey.playerId())).execute();
    }
}

